/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.CQ;
import ca.uhn.hl7v2.model.v231.datatype.EI;
import ca.uhn.hl7v2.model.v231.datatype.EIP;
import ca.uhn.hl7v2.model.v231.datatype.ID;
import ca.uhn.hl7v2.model.v231.datatype.MOC;
import ca.uhn.hl7v2.model.v231.datatype.NDL;
import ca.uhn.hl7v2.model.v231.datatype.NM;
import ca.uhn.hl7v2.model.v231.datatype.PRL;
import ca.uhn.hl7v2.model.v231.datatype.SI;
import ca.uhn.hl7v2.model.v231.datatype.SPS;
import ca.uhn.hl7v2.model.v231.datatype.ST;
import ca.uhn.hl7v2.model.v231.datatype.TQ;
import ca.uhn.hl7v2.model.v231.datatype.TS;
import ca.uhn.hl7v2.model.v231.datatype.XCN;
import ca.uhn.hl7v2.model.v231.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OBR
extends AbstractSegment {
    public OBR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - OBR");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Placer Order Number");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Filler Order Number");
            this.add(CE.class, true, 1, 200, new Object[]{this.getMessage()}, "Universal Service ID");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Priority-OBR");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Requested Date/time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Observation Date/Time #");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Observation End Date/Time #");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Collection Volume *");
            this.add(XCN.class, false, 0, 60, new Object[]{this.getMessage()}, "Collector Identifier *");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(65)}, "Specimen Action Code *");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Danger Code");
            this.add(ST.class, false, 1, 300, new Object[]{this.getMessage()}, "Relevant Clinical Info.");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Specimen Received Date/Time *");
            this.add(SPS.class, false, 1, 300, new Object[]{this.getMessage()}, "Specimen Source");
            this.add(XCN.class, false, 0, 120, new Object[]{this.getMessage()}, "Ordering Provider");
            this.add(XTN.class, false, 2, 40, new Object[]{this.getMessage()}, "Order Callback Phone Number");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Placer Field 1");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Placer Field 2");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Filler Field 1 +");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Filler Field 2 +");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Results Rpt/Status Chng - Date/Time +");
            this.add(MOC.class, false, 1, 40, new Object[]{this.getMessage()}, "Charge to Practice +");
            this.add(ID.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(74)}, "Diagnostic Serv Sect ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(123)}, "Result Status +");
            this.add(PRL.class, false, 1, 200, new Object[]{this.getMessage()}, "Parent Result +");
            this.add(TQ.class, false, 0, 200, new Object[]{this.getMessage()}, "Quantity/Timing");
            this.add(XCN.class, false, 5, 150, new Object[]{this.getMessage()}, "Result Copies To");
            this.add(EIP.class, false, 1, 200, new Object[]{this.getMessage()}, "Parent Number");
            this.add(ID.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(124)}, "Transportation Mode");
            this.add(CE.class, false, 0, 300, new Object[]{this.getMessage()}, "Reason for Study");
            this.add(NDL.class, false, 1, 200, new Object[]{this.getMessage()}, "Principal Result Interpreter +");
            this.add(NDL.class, false, 0, 200, new Object[]{this.getMessage()}, "Assistant Result Interpreter +");
            this.add(NDL.class, false, 0, 200, new Object[]{this.getMessage()}, "Technician +");
            this.add(NDL.class, false, 0, 200, new Object[]{this.getMessage()}, "Transcriptionist +");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Scheduled Date/Time +");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Number of Sample Containers *");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Transport Logistics of Collected Sample *");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Collector\u2019s Comment *");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Transport Arrangement Responsibility");
            this.add(ID.class, false, 1, 30, new Object[]{this.getMessage(), new Integer(224)}, "Transport Arranged");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(225)}, "Escort Required");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Planned Patient Transport Comment");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(CE.class, false, 0, 80, new Object[]{this.getMessage()}, "Procedure Code Modifier");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OBR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDOBR() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getObr1_SetIDOBR() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPlacerOrderNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getObr2_PlacerOrderNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getFillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getObr3_FillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getUniversalServiceID() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getObr4_UniversalServiceID() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getPriorityOBR() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getObr5_PriorityOBR() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getRequestedDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getObr6_RequestedDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getObservationDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getObr7_ObservationDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getObservationEndDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getObr8_ObservationEndDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getObr9_CollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public XCN[] getCollectorIdentifier() {
        XCN[] retVal = (XCN[])this.getTypedField(10, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getObr10_CollectorIdentifier() {
        XCN[] retVal = (XCN[])this.getTypedField(10, (Type[])new XCN[0]);
        return retVal;
    }

    public int getCollectorIdentifierReps() {
        return this.getReps(10);
    }

    public XCN getCollectorIdentifier(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public XCN getObr10_CollectorIdentifier(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getObr10_CollectorIdentifierReps() {
        return this.getReps(10);
    }

    public XCN insertCollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN insertObr10_CollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN removeCollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public XCN removeObr10_CollectorIdentifier(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public ID getSpecimenActionCode() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getObr11_SpecimenActionCode() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getDangerCode() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getObr12_DangerCode() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getRelevantClinicalInfo() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getObr13_RelevantClinicalInfo() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getSpecimenReceivedDateTime() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getObr14_SpecimenReceivedDateTime() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public SPS getSpecimenSource() {
        SPS retVal = (SPS)this.getTypedField(15, 0);
        return retVal;
    }

    public SPS getObr15_SpecimenSource() {
        SPS retVal = (SPS)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN[] getOrderingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(16, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getObr16_OrderingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(16, (Type[])new XCN[0]);
        return retVal;
    }

    public int getOrderingProviderReps() {
        return this.getReps(16);
    }

    public XCN getOrderingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public XCN getObr16_OrderingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getObr16_OrderingProviderReps() {
        return this.getReps(16);
    }

    public XCN insertOrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN insertObr16_OrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN removeOrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XCN removeObr16_OrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XTN[] getOrderCallbackPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(17, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getObr17_OrderCallbackPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(17, (Type[])new XTN[0]);
        return retVal;
    }

    public int getOrderCallbackPhoneNumberReps() {
        return this.getReps(17);
    }

    public XTN getOrderCallbackPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(17, rep);
        return retVal;
    }

    public XTN getObr17_OrderCallbackPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(17, rep);
        return retVal;
    }

    public int getObr17_OrderCallbackPhoneNumberReps() {
        return this.getReps(17);
    }

    public XTN insertOrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(17, rep);
    }

    public XTN insertObr17_OrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(17, rep);
    }

    public XTN removeOrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(17, rep);
    }

    public XTN removeObr17_OrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(17, rep);
    }

    public ST getPlacerField1() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getObr18_PlacerField1() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getPlacerField2() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getObr19_PlacerField2() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getFillerField1() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getObr20_FillerField1() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getFillerField2() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getObr21_FillerField2() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public TS getResultsRptStatusChngDateTime() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public TS getObr22_ResultsRptStatusChngDateTime() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public MOC getChargeToPractice() {
        MOC retVal = (MOC)this.getTypedField(23, 0);
        return retVal;
    }

    public MOC getObr23_ChargeToPractice() {
        MOC retVal = (MOC)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getDiagnosticServSectID() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getObr24_DiagnosticServSectID() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getResultStatus() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getObr25_ResultStatus() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public PRL getParentResult() {
        PRL retVal = (PRL)this.getTypedField(26, 0);
        return retVal;
    }

    public PRL getObr26_ParentResult() {
        PRL retVal = (PRL)this.getTypedField(26, 0);
        return retVal;
    }

    public TQ[] getQuantityTiming() {
        TQ[] retVal = (TQ[])this.getTypedField(27, (Type[])new TQ[0]);
        return retVal;
    }

    public TQ[] getObr27_QuantityTiming() {
        TQ[] retVal = (TQ[])this.getTypedField(27, (Type[])new TQ[0]);
        return retVal;
    }

    public int getQuantityTimingReps() {
        return this.getReps(27);
    }

    public TQ getQuantityTiming(int rep) {
        TQ retVal = (TQ)this.getTypedField(27, rep);
        return retVal;
    }

    public TQ getObr27_QuantityTiming(int rep) {
        TQ retVal = (TQ)this.getTypedField(27, rep);
        return retVal;
    }

    public int getObr27_QuantityTimingReps() {
        return this.getReps(27);
    }

    public TQ insertQuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(27, rep);
    }

    public TQ insertObr27_QuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(27, rep);
    }

    public TQ removeQuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(27, rep);
    }

    public TQ removeObr27_QuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(27, rep);
    }

    public XCN[] getResultCopiesTo() {
        XCN[] retVal = (XCN[])this.getTypedField(28, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getObr28_ResultCopiesTo() {
        XCN[] retVal = (XCN[])this.getTypedField(28, (Type[])new XCN[0]);
        return retVal;
    }

    public int getResultCopiesToReps() {
        return this.getReps(28);
    }

    public XCN getResultCopiesTo(int rep) {
        XCN retVal = (XCN)this.getTypedField(28, rep);
        return retVal;
    }

    public XCN getObr28_ResultCopiesTo(int rep) {
        XCN retVal = (XCN)this.getTypedField(28, rep);
        return retVal;
    }

    public int getObr28_ResultCopiesToReps() {
        return this.getReps(28);
    }

    public XCN insertResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(28, rep);
    }

    public XCN insertObr28_ResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(28, rep);
    }

    public XCN removeResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(28, rep);
    }

    public XCN removeObr28_ResultCopiesTo(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(28, rep);
    }

    public EIP getParentNumber() {
        EIP retVal = (EIP)this.getTypedField(29, 0);
        return retVal;
    }

    public EIP getObr29_ParentNumber() {
        EIP retVal = (EIP)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getTransportationMode() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getObr30_TransportationMode() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public CE[] getReasonForStudy() {
        CE[] retVal = (CE[])this.getTypedField(31, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getObr31_ReasonForStudy() {
        CE[] retVal = (CE[])this.getTypedField(31, (Type[])new CE[0]);
        return retVal;
    }

    public int getReasonForStudyReps() {
        return this.getReps(31);
    }

    public CE getReasonForStudy(int rep) {
        CE retVal = (CE)this.getTypedField(31, rep);
        return retVal;
    }

    public CE getObr31_ReasonForStudy(int rep) {
        CE retVal = (CE)this.getTypedField(31, rep);
        return retVal;
    }

    public int getObr31_ReasonForStudyReps() {
        return this.getReps(31);
    }

    public CE insertReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE insertObr31_ReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE removeReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CE removeObr31_ReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public NDL getPrincipalResultInterpreter() {
        NDL retVal = (NDL)this.getTypedField(32, 0);
        return retVal;
    }

    public NDL getObr32_PrincipalResultInterpreter() {
        NDL retVal = (NDL)this.getTypedField(32, 0);
        return retVal;
    }

    public NDL[] getAssistantResultInterpreter() {
        NDL[] retVal = (NDL[])this.getTypedField(33, (Type[])new NDL[0]);
        return retVal;
    }

    public NDL[] getObr33_AssistantResultInterpreter() {
        NDL[] retVal = (NDL[])this.getTypedField(33, (Type[])new NDL[0]);
        return retVal;
    }

    public int getAssistantResultInterpreterReps() {
        return this.getReps(33);
    }

    public NDL getAssistantResultInterpreter(int rep) {
        NDL retVal = (NDL)this.getTypedField(33, rep);
        return retVal;
    }

    public NDL getObr33_AssistantResultInterpreter(int rep) {
        NDL retVal = (NDL)this.getTypedField(33, rep);
        return retVal;
    }

    public int getObr33_AssistantResultInterpreterReps() {
        return this.getReps(33);
    }

    public NDL insertAssistantResultInterpreter(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(33, rep);
    }

    public NDL insertObr33_AssistantResultInterpreter(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(33, rep);
    }

    public NDL removeAssistantResultInterpreter(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(33, rep);
    }

    public NDL removeObr33_AssistantResultInterpreter(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(33, rep);
    }

    public NDL[] getTechnician() {
        NDL[] retVal = (NDL[])this.getTypedField(34, (Type[])new NDL[0]);
        return retVal;
    }

    public NDL[] getObr34_Technician() {
        NDL[] retVal = (NDL[])this.getTypedField(34, (Type[])new NDL[0]);
        return retVal;
    }

    public int getTechnicianReps() {
        return this.getReps(34);
    }

    public NDL getTechnician(int rep) {
        NDL retVal = (NDL)this.getTypedField(34, rep);
        return retVal;
    }

    public NDL getObr34_Technician(int rep) {
        NDL retVal = (NDL)this.getTypedField(34, rep);
        return retVal;
    }

    public int getObr34_TechnicianReps() {
        return this.getReps(34);
    }

    public NDL insertTechnician(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(34, rep);
    }

    public NDL insertObr34_Technician(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(34, rep);
    }

    public NDL removeTechnician(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(34, rep);
    }

    public NDL removeObr34_Technician(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(34, rep);
    }

    public NDL[] getTranscriptionist() {
        NDL[] retVal = (NDL[])this.getTypedField(35, (Type[])new NDL[0]);
        return retVal;
    }

    public NDL[] getObr35_Transcriptionist() {
        NDL[] retVal = (NDL[])this.getTypedField(35, (Type[])new NDL[0]);
        return retVal;
    }

    public int getTranscriptionistReps() {
        return this.getReps(35);
    }

    public NDL getTranscriptionist(int rep) {
        NDL retVal = (NDL)this.getTypedField(35, rep);
        return retVal;
    }

    public NDL getObr35_Transcriptionist(int rep) {
        NDL retVal = (NDL)this.getTypedField(35, rep);
        return retVal;
    }

    public int getObr35_TranscriptionistReps() {
        return this.getReps(35);
    }

    public NDL insertTranscriptionist(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(35, rep);
    }

    public NDL insertObr35_Transcriptionist(int rep) throws HL7Exception {
        return (NDL)super.insertRepetition(35, rep);
    }

    public NDL removeTranscriptionist(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(35, rep);
    }

    public NDL removeObr35_Transcriptionist(int rep) throws HL7Exception {
        return (NDL)super.removeRepetition(35, rep);
    }

    public TS getScheduledDateTime() {
        TS retVal = (TS)this.getTypedField(36, 0);
        return retVal;
    }

    public TS getObr36_ScheduledDateTime() {
        TS retVal = (TS)this.getTypedField(36, 0);
        return retVal;
    }

    public NM getNumberOfSampleContainers() {
        NM retVal = (NM)this.getTypedField(37, 0);
        return retVal;
    }

    public NM getObr37_NumberOfSampleContainers() {
        NM retVal = (NM)this.getTypedField(37, 0);
        return retVal;
    }

    public CE[] getTransportLogisticsOfCollectedSample() {
        CE[] retVal = (CE[])this.getTypedField(38, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getObr38_TransportLogisticsOfCollectedSample() {
        CE[] retVal = (CE[])this.getTypedField(38, (Type[])new CE[0]);
        return retVal;
    }

    public int getTransportLogisticsOfCollectedSampleReps() {
        return this.getReps(38);
    }

    public CE getTransportLogisticsOfCollectedSample(int rep) {
        CE retVal = (CE)this.getTypedField(38, rep);
        return retVal;
    }

    public CE getObr38_TransportLogisticsOfCollectedSample(int rep) {
        CE retVal = (CE)this.getTypedField(38, rep);
        return retVal;
    }

    public int getObr38_TransportLogisticsOfCollectedSampleReps() {
        return this.getReps(38);
    }

    public CE insertTransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(38, rep);
    }

    public CE insertObr38_TransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(38, rep);
    }

    public CE removeTransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(38, rep);
    }

    public CE removeObr38_TransportLogisticsOfCollectedSample(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(38, rep);
    }

    public CE[] getCollectorSComment() {
        CE[] retVal = (CE[])this.getTypedField(39, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getObr39_CollectorSComment() {
        CE[] retVal = (CE[])this.getTypedField(39, (Type[])new CE[0]);
        return retVal;
    }

    public int getCollectorSCommentReps() {
        return this.getReps(39);
    }

    public CE getCollectorSComment(int rep) {
        CE retVal = (CE)this.getTypedField(39, rep);
        return retVal;
    }

    public CE getObr39_CollectorSComment(int rep) {
        CE retVal = (CE)this.getTypedField(39, rep);
        return retVal;
    }

    public int getObr39_CollectorSCommentReps() {
        return this.getReps(39);
    }

    public CE insertCollectorSComment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(39, rep);
    }

    public CE insertObr39_CollectorSComment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(39, rep);
    }

    public CE removeCollectorSComment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(39, rep);
    }

    public CE removeObr39_CollectorSComment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(39, rep);
    }

    public CE getTransportArrangementResponsibility() {
        CE retVal = (CE)this.getTypedField(40, 0);
        return retVal;
    }

    public CE getObr40_TransportArrangementResponsibility() {
        CE retVal = (CE)this.getTypedField(40, 0);
        return retVal;
    }

    public ID getTransportArranged() {
        ID retVal = (ID)this.getTypedField(41, 0);
        return retVal;
    }

    public ID getObr41_TransportArranged() {
        ID retVal = (ID)this.getTypedField(41, 0);
        return retVal;
    }

    public ID getEscortRequired() {
        ID retVal = (ID)this.getTypedField(42, 0);
        return retVal;
    }

    public ID getObr42_EscortRequired() {
        ID retVal = (ID)this.getTypedField(42, 0);
        return retVal;
    }

    public CE[] getPlannedPatientTransportComment() {
        CE[] retVal = (CE[])this.getTypedField(43, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getObr43_PlannedPatientTransportComment() {
        CE[] retVal = (CE[])this.getTypedField(43, (Type[])new CE[0]);
        return retVal;
    }

    public int getPlannedPatientTransportCommentReps() {
        return this.getReps(43);
    }

    public CE getPlannedPatientTransportComment(int rep) {
        CE retVal = (CE)this.getTypedField(43, rep);
        return retVal;
    }

    public CE getObr43_PlannedPatientTransportComment(int rep) {
        CE retVal = (CE)this.getTypedField(43, rep);
        return retVal;
    }

    public int getObr43_PlannedPatientTransportCommentReps() {
        return this.getReps(43);
    }

    public CE insertPlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(43, rep);
    }

    public CE insertObr43_PlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(43, rep);
    }

    public CE removePlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(43, rep);
    }

    public CE removeObr43_PlannedPatientTransportComment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(43, rep);
    }

    public CE getProcedureCode() {
        CE retVal = (CE)this.getTypedField(44, 0);
        return retVal;
    }

    public CE getObr44_ProcedureCode() {
        CE retVal = (CE)this.getTypedField(44, 0);
        return retVal;
    }

    public CE[] getProcedureCodeModifier() {
        CE[] retVal = (CE[])this.getTypedField(45, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getObr45_ProcedureCodeModifier() {
        CE[] retVal = (CE[])this.getTypedField(45, (Type[])new CE[0]);
        return retVal;
    }

    public int getProcedureCodeModifierReps() {
        return this.getReps(45);
    }

    public CE getProcedureCodeModifier(int rep) {
        CE retVal = (CE)this.getTypedField(45, rep);
        return retVal;
    }

    public CE getObr45_ProcedureCodeModifier(int rep) {
        CE retVal = (CE)this.getTypedField(45, rep);
        return retVal;
    }

    public int getObr45_ProcedureCodeModifierReps() {
        return this.getReps(45);
    }

    public CE insertProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(45, rep);
    }

    public CE insertObr45_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(45, rep);
    }

    public CE removeProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(45, rep);
    }

    public CE removeObr45_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(45, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new CQ(this.getMessage());
            }
            case 9: {
                return new XCN(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(65));
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new SPS(this.getMessage());
            }
            case 15: {
                return new XCN(this.getMessage());
            }
            case 16: {
                return new XTN(this.getMessage());
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new TS(this.getMessage());
            }
            case 22: {
                return new MOC(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(74));
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(123));
            }
            case 25: {
                return new PRL(this.getMessage());
            }
            case 26: {
                return new TQ(this.getMessage());
            }
            case 27: {
                return new XCN(this.getMessage());
            }
            case 28: {
                return new EIP(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(124));
            }
            case 30: {
                return new CE(this.getMessage());
            }
            case 31: {
                return new NDL(this.getMessage());
            }
            case 32: {
                return new NDL(this.getMessage());
            }
            case 33: {
                return new NDL(this.getMessage());
            }
            case 34: {
                return new NDL(this.getMessage());
            }
            case 35: {
                return new TS(this.getMessage());
            }
            case 36: {
                return new NM(this.getMessage());
            }
            case 37: {
                return new CE(this.getMessage());
            }
            case 38: {
                return new CE(this.getMessage());
            }
            case 39: {
                return new CE(this.getMessage());
            }
            case 40: {
                return new ID(this.getMessage(), new Integer(224));
            }
            case 41: {
                return new ID(this.getMessage(), new Integer(225));
            }
            case 42: {
                return new CE(this.getMessage());
            }
            case 43: {
                return new CE(this.getMessage());
            }
            case 44: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

