/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.segment.CDM;
import ca.uhn.hl7v2.model.v251.segment.MFE;
import ca.uhn.hl7v2.model.v251.segment.PRC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M04_MF_CDM
extends AbstractGroup {
    public MFN_M04_MF_CDM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false);
            this.add(CDM.class, true, false);
            this.add(PRC.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating MFN_M04_MF_CDM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MFE getMFE() {
        MFE ret = null;
        try {
            ret = (MFE)this.get("MFE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CDM getCDM() {
        CDM ret = null;
        try {
            ret = (CDM)this.get("CDM");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRC getPRC() {
        PRC ret = null;
        try {
            ret = (PRC)this.get("PRC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRC getPRC(int rep) {
        PRC ret = null;
        try {
            ret = (PRC)this.get("PRC", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRCReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<PRC> getPRCAll() throws HL7Exception {
        return this.getAllAsList("PRC", PRC.class);
    }

    public void insertPRC(PRC structure, int rep) throws HL7Exception {
        super.insertRepetition("PRC", (Structure)structure, rep);
    }

    public PRC insertPRC(int rep) throws HL7Exception {
        return (PRC)super.insertRepetition("PRC", rep);
    }

    public PRC removePRC(int rep) throws HL7Exception {
        return (PRC)super.removeRepetition("PRC", rep);
    }
}

