/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.ORL_O36_SPECIMEN;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORL_O36_PATIENT
extends AbstractGroup {
    public ORL_O36_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(ORL_O36_SPECIMEN.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ORL_O36_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORL_O36_SPECIMEN getSPECIMEN() {
        ORL_O36_SPECIMEN ret = null;
        try {
            ret = (ORL_O36_SPECIMEN)this.get("SPECIMEN");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORL_O36_SPECIMEN getSPECIMEN(int rep) {
        ORL_O36_SPECIMEN ret = null;
        try {
            ret = (ORL_O36_SPECIMEN)this.get("SPECIMEN", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSPECIMENReps() {
        int reps = -1;
        try {
            reps = this.getAll("SPECIMEN").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ORL_O36_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", ORL_O36_SPECIMEN.class);
    }

    public void insertSPECIMEN(ORL_O36_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", (Structure)structure, rep);
    }

    public ORL_O36_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O36_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public ORL_O36_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O36_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

