/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.RSP_Z82_ENCODED_ORDER;
import ca.uhn.hl7v2.model.v251.group.RSP_Z82_OBSERVATION;
import ca.uhn.hl7v2.model.v251.group.RSP_Z82_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v251.group.RSP_Z82_TIMING;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.model.v251.segment.RXC;
import ca.uhn.hl7v2.model.v251.segment.RXD;
import ca.uhn.hl7v2.model.v251.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSP_Z82_COMMON_ORDER
extends AbstractGroup {
    public RSP_Z82_COMMON_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RSP_Z82_TIMING.class, false, true);
            this.add(RSP_Z82_ORDER_DETAIL.class, false, false);
            this.add(RSP_Z82_ENCODED_ORDER.class, false, false);
            this.add(RXD.class, true, false);
            this.add(RXR.class, true, true);
            this.add(RXC.class, false, true);
            this.add(RSP_Z82_OBSERVATION.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating RSP_Z82_COMMON_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z82_TIMING getTIMING() {
        RSP_Z82_TIMING ret = null;
        try {
            ret = (RSP_Z82_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z82_TIMING getTIMING(int rep) {
        RSP_Z82_TIMING ret = null;
        try {
            ret = (RSP_Z82_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RSP_Z82_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RSP_Z82_TIMING.class);
    }

    public void insertTIMING(RSP_Z82_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RSP_Z82_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RSP_Z82_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RSP_Z82_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RSP_Z82_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RSP_Z82_ORDER_DETAIL getORDER_DETAIL() {
        RSP_Z82_ORDER_DETAIL ret = null;
        try {
            ret = (RSP_Z82_ORDER_DETAIL)this.get("ORDER_DETAIL");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z82_ENCODED_ORDER getENCODED_ORDER() {
        RSP_Z82_ENCODED_ORDER ret = null;
        try {
            ret = (RSP_Z82_ENCODED_ORDER)this.get("ENCODED_ORDER");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXD getRXD() {
        RXD ret = null;
        try {
            ret = (RXD)this.get("RXD");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXR getRXR() {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXR getRXR(int rep) {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRXRReps() {
        int reps = -1;
        try {
            reps = this.getAll("RXR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC ret = null;
        try {
            ret = (RXC)this.get("RXC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXC getRXC(int rep) {
        RXC ret = null;
        try {
            ret = (RXC)this.get("RXC", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRXCReps() {
        int reps = -1;
        try {
            reps = this.getAll("RXC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RXC> getRXCAll() throws HL7Exception {
        return this.getAllAsList("RXC", RXC.class);
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", (Structure)structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }

    public RSP_Z82_OBSERVATION getOBSERVATION() {
        RSP_Z82_OBSERVATION ret = null;
        try {
            ret = (RSP_Z82_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z82_OBSERVATION getOBSERVATION(int rep) {
        RSP_Z82_OBSERVATION ret = null;
        try {
            ret = (RSP_Z82_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RSP_Z82_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RSP_Z82_OBSERVATION.class);
    }

    public void insertOBSERVATION(RSP_Z82_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RSP_Z82_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z82_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RSP_Z82_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z82_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

