/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.CSU_C09_PATIENT;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CSU_C09
extends AbstractMessage {
    public CSU_C09() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public CSU_C09(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(CSU_C09_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CSU_C09 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public CSU_C09_PATIENT getPATIENT() {
        return (CSU_C09_PATIENT)this.getTyped("PATIENT", CSU_C09_PATIENT.class);
    }

    public CSU_C09_PATIENT getPATIENT(int rep) {
        return (CSU_C09_PATIENT)this.getTyped("PATIENT", rep, CSU_C09_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<CSU_C09_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", CSU_C09_PATIENT.class);
    }

    public void insertPATIENT(CSU_C09_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public CSU_C09_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (CSU_C09_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public CSU_C09_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (CSU_C09_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

