/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CWE;
import ca.uhn.hl7v2.model.v251.datatype.ED;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.SI;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.model.v251.datatype.XCN;
import ca.uhn.hl7v2.model.v251.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CER
extends AbstractSegment {
    public CER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - CER");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Serial Number");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Version");
            this.add(XON.class, false, 1, 250, new Object[]{this.getMessage()}, "Granting Authority");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Issuing Authority");
            this.add(ED.class, false, 1, 65536, new Object[]{this.getMessage()}, "Signature of Issuing Authority");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(399)}, "Granting Country");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Granting State/Province");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Granting County/Parish");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Certificate Type");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Certificate Domain");
            this.add(ID.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Subject ID");
            this.add(ST.class, true, 1, 250, new Object[]{this.getMessage()}, "Subject Name");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Subject Directory Attribute Extension (Health Professional Data)");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Subject Public Key Info");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Authority Key Identifier");
            this.add(ID.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(136)}, "Basic Constraint");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "CRL Distribution Point");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(399)}, "Jurisdiction Country");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Jurisdiction State/Province");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Jurisdiction County/Parish");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Jurisdiction Breadth");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Granting Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Issuing Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Activation Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Inactivation Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Expiration Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Renewal Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Revocation Date");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Revocation Reason Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Certificate Status");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDCER() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getCer1_SetIDCER() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getSerialNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getCer2_SerialNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getVersion() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getCer3_Version() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public XON getGrantingAuthority() {
        XON retVal = (XON)this.getTypedField(4, 0);
        return retVal;
    }

    public XON getCer4_GrantingAuthority() {
        XON retVal = (XON)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN getIssuingAuthority() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public XCN getCer5_IssuingAuthority() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public ED getSignatureOfIssuingAuthority() {
        ED retVal = (ED)this.getTypedField(6, 0);
        return retVal;
    }

    public ED getCer6_SignatureOfIssuingAuthority() {
        ED retVal = (ED)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getGrantingCountry() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getCer7_GrantingCountry() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getGrantingStateProvince() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getCer8_GrantingStateProvince() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getGrantingCountyParish() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getCer9_GrantingCountyParish() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getCertificateType() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getCer10_CertificateType() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getCertificateDomain() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getCer11_CertificateDomain() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getSubjectID() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getCer12_SubjectID() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getSubjectName() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getCer13_SubjectName() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE[] getSubjectDirectoryAttributeExtensionHealthProfessionalData() {
        CWE[] retVal = (CWE[])this.getTypedField(14, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCer14_SubjectDirectoryAttributeExtensionHealthProfessionalData() {
        CWE[] retVal = (CWE[])this.getTypedField(14, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSubjectDirectoryAttributeExtensionHealthProfessionalDataReps() {
        return this.getReps(14);
    }

    public CWE getSubjectDirectoryAttributeExtensionHealthProfessionalData(int rep) {
        CWE retVal = (CWE)this.getTypedField(14, rep);
        return retVal;
    }

    public CWE getCer14_SubjectDirectoryAttributeExtensionHealthProfessionalData(int rep) {
        CWE retVal = (CWE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getCer14_SubjectDirectoryAttributeExtensionHealthProfessionalDataReps() {
        return this.getReps(14);
    }

    public CWE insertSubjectDirectoryAttributeExtensionHealthProfessionalData(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(14, rep);
    }

    public CWE insertCer14_SubjectDirectoryAttributeExtensionHealthProfessionalData(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(14, rep);
    }

    public CWE removeSubjectDirectoryAttributeExtensionHealthProfessionalData(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(14, rep);
    }

    public CWE removeCer14_SubjectDirectoryAttributeExtensionHealthProfessionalData(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(14, rep);
    }

    public CWE getSubjectPublicKeyInfo() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getCer15_SubjectPublicKeyInfo() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getAuthorityKeyIdentifier() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getCer16_AuthorityKeyIdentifier() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getBasicConstraint() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getCer17_BasicConstraint() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE[] getCRLDistributionPoint() {
        CWE[] retVal = (CWE[])this.getTypedField(18, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCer18_CRLDistributionPoint() {
        CWE[] retVal = (CWE[])this.getTypedField(18, (Type[])new CWE[0]);
        return retVal;
    }

    public int getCRLDistributionPointReps() {
        return this.getReps(18);
    }

    public CWE getCRLDistributionPoint(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public CWE getCer18_CRLDistributionPoint(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public int getCer18_CRLDistributionPointReps() {
        return this.getReps(18);
    }

    public CWE insertCRLDistributionPoint(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE insertCer18_CRLDistributionPoint(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE removeCRLDistributionPoint(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public CWE removeCer18_CRLDistributionPoint(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public ID getJurisdictionCountry() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getCer19_JurisdictionCountry() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE getJurisdictionStateProvince() {
        CWE retVal = (CWE)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getCer20_JurisdictionStateProvince() {
        CWE retVal = (CWE)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getJurisdictionCountyParish() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getCer21_JurisdictionCountyParish() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE[] getJurisdictionBreadth() {
        CWE[] retVal = (CWE[])this.getTypedField(22, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCer22_JurisdictionBreadth() {
        CWE[] retVal = (CWE[])this.getTypedField(22, (Type[])new CWE[0]);
        return retVal;
    }

    public int getJurisdictionBreadthReps() {
        return this.getReps(22);
    }

    public CWE getJurisdictionBreadth(int rep) {
        CWE retVal = (CWE)this.getTypedField(22, rep);
        return retVal;
    }

    public CWE getCer22_JurisdictionBreadth(int rep) {
        CWE retVal = (CWE)this.getTypedField(22, rep);
        return retVal;
    }

    public int getCer22_JurisdictionBreadthReps() {
        return this.getReps(22);
    }

    public CWE insertJurisdictionBreadth(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(22, rep);
    }

    public CWE insertCer22_JurisdictionBreadth(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(22, rep);
    }

    public CWE removeJurisdictionBreadth(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(22, rep);
    }

    public CWE removeCer22_JurisdictionBreadth(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(22, rep);
    }

    public TS getGrantingDate() {
        TS retVal = (TS)this.getTypedField(23, 0);
        return retVal;
    }

    public TS getCer23_GrantingDate() {
        TS retVal = (TS)this.getTypedField(23, 0);
        return retVal;
    }

    public TS getIssuingDate() {
        TS retVal = (TS)this.getTypedField(24, 0);
        return retVal;
    }

    public TS getCer24_IssuingDate() {
        TS retVal = (TS)this.getTypedField(24, 0);
        return retVal;
    }

    public TS getActivationDate() {
        TS retVal = (TS)this.getTypedField(25, 0);
        return retVal;
    }

    public TS getCer25_ActivationDate() {
        TS retVal = (TS)this.getTypedField(25, 0);
        return retVal;
    }

    public TS getInactivationDate() {
        TS retVal = (TS)this.getTypedField(26, 0);
        return retVal;
    }

    public TS getCer26_InactivationDate() {
        TS retVal = (TS)this.getTypedField(26, 0);
        return retVal;
    }

    public TS getExpirationDate() {
        TS retVal = (TS)this.getTypedField(27, 0);
        return retVal;
    }

    public TS getCer27_ExpirationDate() {
        TS retVal = (TS)this.getTypedField(27, 0);
        return retVal;
    }

    public TS getRenewalDate() {
        TS retVal = (TS)this.getTypedField(28, 0);
        return retVal;
    }

    public TS getCer28_RenewalDate() {
        TS retVal = (TS)this.getTypedField(28, 0);
        return retVal;
    }

    public TS getRevocationDate() {
        TS retVal = (TS)this.getTypedField(29, 0);
        return retVal;
    }

    public TS getCer29_RevocationDate() {
        TS retVal = (TS)this.getTypedField(29, 0);
        return retVal;
    }

    public CE getRevocationReasonCode() {
        CE retVal = (CE)this.getTypedField(30, 0);
        return retVal;
    }

    public CE getCer30_RevocationReasonCode() {
        CE retVal = (CE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getCertificateStatus() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getCer31_CertificateStatus() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new XON(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new ED(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(399));
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(399));
            }
            case 19: {
                return new CWE(this.getMessage());
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new CWE(this.getMessage());
            }
            case 22: {
                return new TS(this.getMessage());
            }
            case 23: {
                return new TS(this.getMessage());
            }
            case 24: {
                return new TS(this.getMessage());
            }
            case 25: {
                return new TS(this.getMessage());
            }
            case 26: {
                return new TS(this.getMessage());
            }
            case 27: {
                return new TS(this.getMessage());
            }
            case 28: {
                return new TS(this.getMessage());
            }
            case 29: {
                return new CE(this.getMessage());
            }
            case 30: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

