/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.PPV_PCA_GOAL_OBSERVATION;
import ca.uhn.hl7v2.model.v26.group.PPV_PCA_GOAL_PATHWAY;
import ca.uhn.hl7v2.model.v26.group.PPV_PCA_GOAL_ROLE;
import ca.uhn.hl7v2.model.v26.group.PPV_PCA_ORDER;
import ca.uhn.hl7v2.model.v26.group.PPV_PCA_PROBLEM;
import ca.uhn.hl7v2.model.v26.segment.GOL;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPV_PCA_GOAL
extends AbstractGroup {
    public PPV_PCA_GOAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(GOL.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(VAR.class, false, true, false);
            this.add(PPV_PCA_GOAL_ROLE.class, false, true, false);
            this.add(PPV_PCA_GOAL_PATHWAY.class, false, true, false);
            this.add(PPV_PCA_GOAL_OBSERVATION.class, false, true, false);
            this.add(PPV_PCA_PROBLEM.class, false, true, false);
            this.add(PPV_PCA_ORDER.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPV_PCA_GOAL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public GOL getGOL() {
        GOL retVal = (GOL)this.getTyped("GOL", GOL.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPV_PCA_GOAL_ROLE getGOAL_ROLE() {
        PPV_PCA_GOAL_ROLE retVal = (PPV_PCA_GOAL_ROLE)this.getTyped("GOAL_ROLE", PPV_PCA_GOAL_ROLE.class);
        return retVal;
    }

    public PPV_PCA_GOAL_ROLE getGOAL_ROLE(int rep) {
        PPV_PCA_GOAL_ROLE retVal = (PPV_PCA_GOAL_ROLE)this.getTyped("GOAL_ROLE", rep, PPV_PCA_GOAL_ROLE.class);
        return retVal;
    }

    public int getGOAL_ROLEReps() {
        return this.getReps("GOAL_ROLE");
    }

    public List<PPV_PCA_GOAL_ROLE> getGOAL_ROLEAll() throws HL7Exception {
        return this.getAllAsList("GOAL_ROLE", PPV_PCA_GOAL_ROLE.class);
    }

    public void insertGOAL_ROLE(PPV_PCA_GOAL_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_ROLE", (Structure)structure, rep);
    }

    public PPV_PCA_GOAL_ROLE insertGOAL_ROLE(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_ROLE)super.insertRepetition("GOAL_ROLE", rep);
    }

    public PPV_PCA_GOAL_ROLE removeGOAL_ROLE(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_ROLE)super.removeRepetition("GOAL_ROLE", rep);
    }

    public PPV_PCA_GOAL_PATHWAY getGOAL_PATHWAY() {
        PPV_PCA_GOAL_PATHWAY retVal = (PPV_PCA_GOAL_PATHWAY)this.getTyped("GOAL_PATHWAY", PPV_PCA_GOAL_PATHWAY.class);
        return retVal;
    }

    public PPV_PCA_GOAL_PATHWAY getGOAL_PATHWAY(int rep) {
        PPV_PCA_GOAL_PATHWAY retVal = (PPV_PCA_GOAL_PATHWAY)this.getTyped("GOAL_PATHWAY", rep, PPV_PCA_GOAL_PATHWAY.class);
        return retVal;
    }

    public int getGOAL_PATHWAYReps() {
        return this.getReps("GOAL_PATHWAY");
    }

    public List<PPV_PCA_GOAL_PATHWAY> getGOAL_PATHWAYAll() throws HL7Exception {
        return this.getAllAsList("GOAL_PATHWAY", PPV_PCA_GOAL_PATHWAY.class);
    }

    public void insertGOAL_PATHWAY(PPV_PCA_GOAL_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_PATHWAY", (Structure)structure, rep);
    }

    public PPV_PCA_GOAL_PATHWAY insertGOAL_PATHWAY(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_PATHWAY)super.insertRepetition("GOAL_PATHWAY", rep);
    }

    public PPV_PCA_GOAL_PATHWAY removeGOAL_PATHWAY(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_PATHWAY)super.removeRepetition("GOAL_PATHWAY", rep);
    }

    public PPV_PCA_GOAL_OBSERVATION getGOAL_OBSERVATION() {
        PPV_PCA_GOAL_OBSERVATION retVal = (PPV_PCA_GOAL_OBSERVATION)this.getTyped("GOAL_OBSERVATION", PPV_PCA_GOAL_OBSERVATION.class);
        return retVal;
    }

    public PPV_PCA_GOAL_OBSERVATION getGOAL_OBSERVATION(int rep) {
        PPV_PCA_GOAL_OBSERVATION retVal = (PPV_PCA_GOAL_OBSERVATION)this.getTyped("GOAL_OBSERVATION", rep, PPV_PCA_GOAL_OBSERVATION.class);
        return retVal;
    }

    public int getGOAL_OBSERVATIONReps() {
        return this.getReps("GOAL_OBSERVATION");
    }

    public List<PPV_PCA_GOAL_OBSERVATION> getGOAL_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("GOAL_OBSERVATION", PPV_PCA_GOAL_OBSERVATION.class);
    }

    public void insertGOAL_OBSERVATION(PPV_PCA_GOAL_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_OBSERVATION", (Structure)structure, rep);
    }

    public PPV_PCA_GOAL_OBSERVATION insertGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_OBSERVATION)super.insertRepetition("GOAL_OBSERVATION", rep);
    }

    public PPV_PCA_GOAL_OBSERVATION removeGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_OBSERVATION)super.removeRepetition("GOAL_OBSERVATION", rep);
    }

    public PPV_PCA_PROBLEM getPROBLEM() {
        PPV_PCA_PROBLEM retVal = (PPV_PCA_PROBLEM)this.getTyped("PROBLEM", PPV_PCA_PROBLEM.class);
        return retVal;
    }

    public PPV_PCA_PROBLEM getPROBLEM(int rep) {
        PPV_PCA_PROBLEM retVal = (PPV_PCA_PROBLEM)this.getTyped("PROBLEM", rep, PPV_PCA_PROBLEM.class);
        return retVal;
    }

    public int getPROBLEMReps() {
        return this.getReps("PROBLEM");
    }

    public List<PPV_PCA_PROBLEM> getPROBLEMAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM", PPV_PCA_PROBLEM.class);
    }

    public void insertPROBLEM(PPV_PCA_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", (Structure)structure, rep);
    }

    public PPV_PCA_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PPV_PCA_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PPV_PCA_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PPV_PCA_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }

    public PPV_PCA_ORDER getORDER() {
        PPV_PCA_ORDER retVal = (PPV_PCA_ORDER)this.getTyped("ORDER", PPV_PCA_ORDER.class);
        return retVal;
    }

    public PPV_PCA_ORDER getORDER(int rep) {
        PPV_PCA_ORDER retVal = (PPV_PCA_ORDER)this.getTyped("ORDER", rep, PPV_PCA_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<PPV_PCA_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", PPV_PCA_ORDER.class);
    }

    public void insertORDER(PPV_PCA_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public PPV_PCA_ORDER insertORDER(int rep) throws HL7Exception {
        return (PPV_PCA_ORDER)super.insertRepetition("ORDER", rep);
    }

    public PPV_PCA_ORDER removeORDER(int rep) throws HL7Exception {
        return (PPV_PCA_ORDER)super.removeRepetition("ORDER", rep);
    }
}

