/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.MDM_T02_COMMON_ORDER;
import ca.uhn.hl7v2.model.v26.group.MDM_T02_OBSERVATION;
import ca.uhn.hl7v2.model.v26.segment.EVN;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.PV1;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.TXA;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDM_T02
extends AbstractMessage {
    public MDM_T02() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MDM_T02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PV1.class, true, false);
            this.add(MDM_T02_COMMON_ORDER.class, false, true);
            this.add(TXA.class, true, false);
            this.add(MDM_T02_OBSERVATION.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MDM_T02 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PV1 getPV1() {
        return (PV1)this.getTyped("PV1", PV1.class);
    }

    public MDM_T02_COMMON_ORDER getCOMMON_ORDER() {
        return (MDM_T02_COMMON_ORDER)this.getTyped("COMMON_ORDER", MDM_T02_COMMON_ORDER.class);
    }

    public MDM_T02_COMMON_ORDER getCOMMON_ORDER(int rep) {
        return (MDM_T02_COMMON_ORDER)this.getTyped("COMMON_ORDER", rep, MDM_T02_COMMON_ORDER.class);
    }

    public int getCOMMON_ORDERReps() {
        return this.getReps("COMMON_ORDER");
    }

    public List<MDM_T02_COMMON_ORDER> getCOMMON_ORDERAll() throws HL7Exception {
        return this.getAllAsList("COMMON_ORDER", MDM_T02_COMMON_ORDER.class);
    }

    public void insertCOMMON_ORDER(MDM_T02_COMMON_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("COMMON_ORDER", (Structure)structure, rep);
    }

    public MDM_T02_COMMON_ORDER insertCOMMON_ORDER(int rep) throws HL7Exception {
        return (MDM_T02_COMMON_ORDER)super.insertRepetition("COMMON_ORDER", rep);
    }

    public MDM_T02_COMMON_ORDER removeCOMMON_ORDER(int rep) throws HL7Exception {
        return (MDM_T02_COMMON_ORDER)super.removeRepetition("COMMON_ORDER", rep);
    }

    public TXA getTXA() {
        return (TXA)this.getTyped("TXA", TXA.class);
    }

    public MDM_T02_OBSERVATION getOBSERVATION() {
        return (MDM_T02_OBSERVATION)this.getTyped("OBSERVATION", MDM_T02_OBSERVATION.class);
    }

    public MDM_T02_OBSERVATION getOBSERVATION(int rep) {
        return (MDM_T02_OBSERVATION)this.getTyped("OBSERVATION", rep, MDM_T02_OBSERVATION.class);
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<MDM_T02_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", MDM_T02_OBSERVATION.class);
    }

    public void insertOBSERVATION(MDM_T02_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public MDM_T02_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (MDM_T02_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public MDM_T02_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (MDM_T02_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

