/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.segment.MFE;
import ca.uhn.hl7v2.model.v26.segment.MFI;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M13
extends AbstractMessage {
    public MFN_M13() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_M13(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFE.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M13 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFE getMFE() {
        return (MFE)this.getTyped("MFE", MFE.class);
    }

    public MFE getMFE(int rep) {
        return (MFE)this.getTyped("MFE", rep, MFE.class);
    }

    public int getMFEReps() {
        return this.getReps("MFE");
    }

    public List<MFE> getMFEAll() throws HL7Exception {
        return this.getAllAsList("MFE", MFE.class);
    }

    public void insertMFE(MFE structure, int rep) throws HL7Exception {
        super.insertRepetition("MFE", (Structure)structure, rep);
    }

    public MFE insertMFE(int rep) throws HL7Exception {
        return (MFE)super.insertRepetition("MFE", rep);
    }

    public MFE removeMFE(int rep) throws HL7Exception {
        return (MFE)super.removeRepetition("MFE", rep);
    }
}

