/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AIS
extends AbstractSegment {
    public AIS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - AIS");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Universal Service Identifier");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Start Date/Time");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Start Date/Time Offset");
            this.add(CNE.class, false, 1, 250, new Object[]{this.getMessage()}, "Start Date/Time Offset Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Duration");
            this.add(CNE.class, false, 1, 250, new Object[]{this.getMessage()}, "Duration Units");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(279)}, "Allow Substitution Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Filler Status Code");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Placer Supplemental Service Information");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Filler Supplemental Service Information");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating AIS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDAIS() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getAis1_SetIDAIS() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getAis2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getUniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getAis3_UniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getAis4_StartDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getStartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getAis5_StartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public CNE getStartDateTimeOffsetUnits() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getAis6_StartDateTimeOffsetUnits() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getDuration() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getAis7_Duration() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public CNE getDurationUnits() {
        CNE retVal = (CNE)this.getTypedField(8, 0);
        return retVal;
    }

    public CNE getAis8_DurationUnits() {
        CNE retVal = (CNE)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getAllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getAis9_AllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getFillerStatusCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getAis10_FillerStatusCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE[] getPlacerSupplementalServiceInformation() {
        CWE[] retVal = (CWE[])this.getTypedField(11, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getAis11_PlacerSupplementalServiceInformation() {
        CWE[] retVal = (CWE[])this.getTypedField(11, (Type[])new CWE[0]);
        return retVal;
    }

    public int getPlacerSupplementalServiceInformationReps() {
        return this.getReps(11);
    }

    public CWE getPlacerSupplementalServiceInformation(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public CWE getAis11_PlacerSupplementalServiceInformation(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getAis11_PlacerSupplementalServiceInformationReps() {
        return this.getReps(11);
    }

    public CWE insertPlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE insertAis11_PlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE removePlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE removeAis11_PlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE[] getFillerSupplementalServiceInformation() {
        CWE[] retVal = (CWE[])this.getTypedField(12, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getAis12_FillerSupplementalServiceInformation() {
        CWE[] retVal = (CWE[])this.getTypedField(12, (Type[])new CWE[0]);
        return retVal;
    }

    public int getFillerSupplementalServiceInformationReps() {
        return this.getReps(12);
    }

    public CWE getFillerSupplementalServiceInformation(int rep) {
        CWE retVal = (CWE)this.getTypedField(12, rep);
        return retVal;
    }

    public CWE getAis12_FillerSupplementalServiceInformation(int rep) {
        CWE retVal = (CWE)this.getTypedField(12, rep);
        return retVal;
    }

    public int getAis12_FillerSupplementalServiceInformationReps() {
        return this.getReps(12);
    }

    public CWE insertFillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(12, rep);
    }

    public CWE insertAis12_FillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(12, rep);
    }

    public CWE removeFillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(12, rep);
    }

    public CWE removeAis12_FillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(12, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new CNE(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new CNE(this.getMessage());
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(279));
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

