/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CSS
extends AbstractSegment {
    public CSS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Study Scheduled Time Point");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Study Scheduled Patient Time Point");
            this.add(CWE.class, false, 3, 705, new Object[]{this.getMessage()}, "Study Quality Control Codes");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CSS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getStudyScheduledTimePoint() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getCss1_StudyScheduledTimePoint() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getStudyScheduledPatientTimePoint() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getCss2_StudyScheduledPatientTimePoint() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE[] getStudyQualityControlCodes() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCss3_StudyQualityControlCodes() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public int getStudyQualityControlCodesReps() {
        return this.getReps(3);
    }

    public CWE getStudyQualityControlCodes(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getCss3_StudyQualityControlCodes(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getCss3_StudyQualityControlCodesReps() {
        return this.getReps(3);
    }

    public CWE insertStudyQualityControlCodes(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertCss3_StudyQualityControlCodes(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removeStudyQualityControlCodes(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removeCss3_StudyQualityControlCodes(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

