/*
 * Decompiled with CFR 0.152.
 */
package io.provis.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.provis.model.Exclusion;
import io.provis.model.ProvisioArtifact;
import io.provis.model.Resource;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArtifactSet {
    private String directory;
    private String reference;
    private String from;
    private List<ProvisioArtifact> artifacts = Lists.newArrayList();
    private List<Resource> resources = Lists.newArrayList();
    private List<ArtifactSet> artifactSets = Lists.newArrayList();
    private List<Exclusion> exclusions;
    private ArtifactSet parent;
    private File outputDirectory;
    private Map<String, ProvisioArtifact> artifactMap = Maps.newLinkedHashMap();
    private Set<ProvisioArtifact> resolvedArtifacts = Sets.newHashSet();

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void addArtifact(ProvisioArtifact artifact) {
        this.artifacts.add(artifact);
    }

    public List<ProvisioArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void addArtifactSet(ArtifactSet artifactSet) {
        this.artifactSets.add(artifactSet);
    }

    public List<ArtifactSet> getArtifactSets() {
        return this.artifactSets;
    }

    public List<Exclusion> getExcludes() {
        return this.exclusions;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public ArtifactSet getParent() {
        return this.parent;
    }

    public void setParent(ArtifactSet parent) {
        this.parent = parent;
    }

    public Set<ProvisioArtifact> getResolvedArtifacts() {
        return this.resolvedArtifacts;
    }

    public void setResolvedArtifacts(Set<ProvisioArtifact> resolvedArtifacts) {
        this.resolvedArtifacts = resolvedArtifacts;
    }

    public Map<String, ProvisioArtifact> getArtifactMap() {
        if (this.artifacts != null) {
            for (ProvisioArtifact artifact : this.artifacts) {
                this.artifactMap.put(artifact.getCoordinate(), artifact);
            }
        }
        return this.artifactMap;
    }

    public String toString() {
        return "ArtifactSet [directory=" + this.directory + ", artifacts=" + this.artifacts + ", artifactSets=" + this.artifactSets + ", parent=" + this.parent + ", resolvedArtifacts=" + this.resolvedArtifacts + "]";
    }

    private Object readResolve() {
        if (this.artifactSets != null) {
            for (ArtifactSet child : this.artifactSets) {
                child.setParent(this);
            }
        }
        return this;
    }
}

