/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.CommonJobTest;
import org.apache.hadoop.mapred.gridmix.GridmixJobSubmissionPolicy;
import org.apache.hadoop.mapred.gridmix.GridmixTestUtils;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.apache.hadoop.util.ExitUtil;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGridmixSubmission
extends CommonJobTest {
    private static File inSpace = new File("src" + File.separator + "test" + File.separator + "resources" + File.separator + "data");

    @BeforeClass
    public static void init() throws IOException {
        GridmixTestUtils.initCluster(TestGridmixSubmission.class);
        System.setProperty("src.test.data", inSpace.getAbsolutePath());
    }

    @AfterClass
    public static void shutDown() throws IOException {
        GridmixTestUtils.shutdownCluster();
    }

    private void verifyWordCountJobStory(JobStory js) {
        Assert.assertNotNull((String)"Null JobStory", (Object)js);
        String expectedJobStory = "WordCount:johndoe:default:1285322645148:3:1";
        String actualJobStory = js.getName() + ":" + js.getUser() + ":" + js.getQueueName() + ":" + js.getSubmissionTime() + ":" + js.getNumberMaps() + ":" + js.getNumberReduces();
        Assert.assertEquals((String)"Unexpected JobStory", (Object)expectedJobStory, (Object)actualJobStory);
    }

    private void expandGzippedTrace(FileSystem fs, Path in, Path out) throws Exception {
        int numRead;
        byte[] buff = new byte[4096];
        GZIPInputStream gis = new GZIPInputStream((InputStream)fs.open(in));
        FSDataOutputStream fsdOs = fs.create(out);
        while ((numRead = gis.read(buff, 0, buff.length)) != -1) {
            fsdOs.write(buff, 0, numRead);
        }
        gis.close();
        fsdOs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testTraceReader() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("src.test.data"));
        rootInputDir = rootInputDir.makeQualified(lfs.getUri(), lfs.getWorkingDirectory());
        Path rootTempDir = new Path(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), "testTraceReader");
        rootTempDir = rootTempDir.makeQualified(lfs.getUri(), lfs.getWorkingDirectory());
        Path inputFile = new Path(rootInputDir, "wordcount.json.gz");
        Path tempFile = new Path(rootTempDir, "gridmix3-wc.json");
        InputStream origStdIn = System.in;
        InputStream tmpIs = null;
        try {
            CommonJobTest.DebugGridmix dgm = new CommonJobTest.DebugGridmix();
            JobStoryProducer jsp = dgm.createJobStoryProducer(inputFile.toString(), conf);
            LOG.info((Object)"Verifying JobStory from compressed trace...");
            this.verifyWordCountJobStory(jsp.getNextJob());
            this.expandGzippedTrace((FileSystem)lfs, inputFile, tempFile);
            jsp = dgm.createJobStoryProducer(tempFile.toString(), conf);
            LOG.info((Object)"Verifying JobStory from uncompressed trace...");
            this.verifyWordCountJobStory(jsp.getNextJob());
            tmpIs = lfs.open(tempFile);
            System.setIn(tmpIs);
            LOG.info((Object)"Verifying JobStory from trace in standard input...");
            jsp = dgm.createJobStoryProducer("-", conf);
            this.verifyWordCountJobStory(jsp.getNextJob());
        }
        finally {
            System.setIn(origStdIn);
            if (tmpIs != null) {
                tmpIs.close();
            }
            lfs.delete(rootTempDir, true);
        }
    }

    @Test(timeout=500000L)
    public void testReplaySubmit() throws Exception {
        policy = GridmixJobSubmissionPolicy.REPLAY;
        LOG.info((Object)(" Replay started at " + System.currentTimeMillis()));
        this.doSubmission(null, false);
        LOG.info((Object)(" Replay ended at " + System.currentTimeMillis()));
    }

    @Test(timeout=500000L)
    public void testStressSubmit() throws Exception {
        policy = GridmixJobSubmissionPolicy.STRESS;
        LOG.info((Object)(" Stress started at " + System.currentTimeMillis()));
        this.doSubmission(null, false);
        LOG.info((Object)(" Stress ended at " + System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testMain() throws Exception {
        SecurityManager securityManager = System.getSecurityManager();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        System.setErr(out);
        ExitUtil.disableSystemExit();
        try {
            String[] argv = new String[]{};
            CommonJobTest.DebugGridmix.main((String[])argv);
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((Object)"ExitException", (Object)e.getMessage());
            ExitUtil.resetFirstExitException();
        }
        finally {
            System.setErr(oldOut);
            System.setSecurityManager(securityManager);
        }
        String print = bytes.toString();
        Assert.assertTrue((boolean)print.contains("Usage: gridmix [-generate <MiB>] [-users URI] [-Dname=value ...] <iopath> <trace>"));
        Assert.assertTrue((boolean)print.contains("e.g. gridmix -generate 100m foo -"));
    }

    static {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.mapred.gridmix")).getLogger().setLevel(Level.DEBUG);
    }
}

