/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.DataOutputStream;
import java.util.Random;
import org.apache.hadoop.hdfs.DFSPacket;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSPacket {
    private static final int chunkSize = 512;
    private static final int checksumSize = 4;
    private static final int maxChunksPerPacket = 4;

    @Test
    public void testPacket() throws Exception {
        Random r = new Random(12345L);
        byte[] data = new byte[512];
        r.nextBytes(data);
        byte[] checksum = new byte[4];
        r.nextBytes(checksum);
        DataOutputBuffer os = new DataOutputBuffer(data.length * 2);
        byte[] packetBuf = new byte[data.length * 2];
        DFSPacket p = new DFSPacket(packetBuf, 4, 0L, 0L, 4, false);
        p.setSyncBlock(true);
        p.writeData(data, 0, data.length);
        p.writeChecksum(checksum, 0, checksum.length);
        p.writeTo((DataOutputStream)os);
        int headerLen = PacketHeader.PKT_MAX_HEADER_LEN;
        byte[] readBuf = os.getData();
        TestDFSPacket.assertArrayRegionsEqual(readBuf, headerLen, checksum, 0, checksum.length);
        TestDFSPacket.assertArrayRegionsEqual(readBuf, headerLen + checksum.length, data, 0, data.length);
    }

    public static void assertArrayRegionsEqual(byte[] buf1, int off1, byte[] buf2, int off2, int len) {
        for (int i = 0; i < len; ++i) {
            if (buf1[off1 + i] == buf2[off2 + i]) continue;
            Assert.fail((String)("arrays differ at byte " + i + ". The first array has " + buf1[off1 + i] + ", but the second array has " + buf2[off2 + i]));
        }
    }

    @Test
    public void testAddParentsGetParents() throws Exception {
        DFSPacket p = new DFSPacket(null, 4, 0L, 0L, 4, false);
        long[] parents = p.getTraceParents();
        Assert.assertEquals((long)0L, (long)parents.length);
        p.addTraceParent(123L);
        p.addTraceParent(123L);
        parents = p.getTraceParents();
        Assert.assertEquals((long)1L, (long)parents.length);
        Assert.assertEquals((long)123L, (long)parents[0]);
        parents = p.getTraceParents();
        Assert.assertEquals((long)1L, (long)parents.length);
        Assert.assertEquals((long)123L, (long)parents[0]);
        p.addTraceParent(1L);
        p.addTraceParent(456L);
        p.addTraceParent(789L);
        parents = p.getTraceParents();
        Assert.assertEquals((long)4L, (long)parents.length);
        Assert.assertEquals((long)1L, (long)parents[0]);
        Assert.assertEquals((long)123L, (long)parents[1]);
        Assert.assertEquals((long)456L, (long)parents[2]);
        Assert.assertEquals((long)789L, (long)parents[3]);
    }
}

