/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

class Histogram
implements Iterable<Map.Entry<Long, Long>> {
    private TreeMap<Long, Long> content = new TreeMap();
    private String name;
    private long totalCount;

    public Histogram() {
        this("(anonymous)");
    }

    public Histogram(String name) {
        this.name = name;
        this.totalCount = 0L;
    }

    public void dump(PrintStream stream) {
        stream.print("dumping Histogram " + this.name + ":\n");
        for (Map.Entry ent : this) {
            stream.print("val/count pair: " + (Long)ent.getKey() + ", " + (Long)ent.getValue() + "\n");
        }
        stream.print("*** end *** \n");
    }

    @Override
    public Iterator<Map.Entry<Long, Long>> iterator() {
        return this.content.entrySet().iterator();
    }

    public long get(long key) {
        Long result = (Long)this.content.get(key);
        return result == null ? 0L : result;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void enter(long value) {
        Long existingValue = (Long)this.content.get(value);
        if (existingValue == null) {
            this.content.put(value, 1L);
        } else {
            this.content.put(value, existingValue + 1L);
        }
        ++this.totalCount;
    }

    public long[] getCDF(int scale, int[] buckets) {
        if (this.totalCount == 0L) {
            return null;
        }
        long[] result = new long[buckets.length + 2];
        result[0] = (Long)this.content.firstEntry().getKey();
        result[buckets.length + 1] = (Long)this.content.lastEntry().getKey();
        Iterator iter = this.content.entrySet().iterator();
        long cumulativeCount = 0L;
        int bucketCursor = 0;
        while (iter.hasNext()) {
            long targetCumulativeCount = (long)buckets[bucketCursor] * this.totalCount / (long)scale;
            Map.Entry elt = iter.next();
            cumulativeCount += ((Long)elt.getValue()).longValue();
            while (cumulativeCount >= targetCumulativeCount) {
                result[bucketCursor + 1] = (Long)elt.getKey();
                if (++bucketCursor >= buckets.length) break;
                targetCumulativeCount = (long)buckets[bucketCursor] * this.totalCount / (long)scale;
            }
            if (bucketCursor != buckets.length) continue;
            break;
        }
        return result;
    }
}

