/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.TreePath;
import org.apache.hadoop.tools.rumen.datatypes.NodeName;
import org.codehaus.jackson.annotate.JsonAnySetter;

public class LoggedLocation
implements DeepCompare {
    static final Map<List<String>, List<NodeName>> layersCache = new HashMap();
    List<NodeName> layers = Collections.emptyList();
    private static Set<String> alreadySeenAnySetterAttributes = new TreeSet();

    public List<NodeName> getLayers() {
        return this.layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLayers(List<String> layers) {
        if (layers == null || layers.isEmpty()) {
            this.layers = Collections.emptyList();
        } else {
            Map map = layersCache;
            synchronized (map) {
                List found = (List)layersCache.get(layers);
                if (found == null) {
                    ArrayList<NodeName> clone = new ArrayList<NodeName>(layers.size());
                    clone.add(new NodeName(layers.get(0).intern(), null));
                    clone.add(new NodeName(null, layers.get(1).intern()));
                    List readonlyLayers = Collections.unmodifiableList(clone);
                    List<String> readonlyLayersKey = Collections.unmodifiableList(layers);
                    layersCache.put(readonlyLayersKey, readonlyLayers);
                    this.layers = readonlyLayers;
                } else {
                    this.layers = found;
                }
            }
        }
    }

    @JsonAnySetter
    public void setUnknownAttribute(String attributeName, Object ignored) {
        if (!alreadySeenAnySetterAttributes.contains(attributeName)) {
            alreadySeenAnySetterAttributes.add(attributeName);
            System.err.println("In LoggedJob, we saw the unknown attribute " + attributeName + ".");
        }
    }

    private void compareStrings(List<NodeName> c1, List<NodeName> c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        TreePath recursePath = new TreePath(loc, eltname);
        if (c1 == null || c2 == null || c1.size() != c2.size()) {
            throw new DeepInequalityException(eltname + " miscompared", recursePath);
        }
        for (NodeName n1 : c1) {
            boolean found = false;
            for (NodeName n2 : c2) {
                if (!n1.getValue().equals(n2.getValue())) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new DeepInequalityException(eltname + " miscompared [" + n1.getValue() + "]", recursePath);
        }
    }

    public void deepCompare(DeepCompare comparand, TreePath loc) throws DeepInequalityException {
        if (!(comparand instanceof LoggedLocation)) {
            throw new DeepInequalityException("comparand has wrong type", loc);
        }
        LoggedLocation other = (LoggedLocation)comparand;
        this.compareStrings(this.layers, other.layers, loc, "layers");
    }
}

