/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.datatypes;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.rumen.datatypes.AnonymizableDataType;
import org.apache.hadoop.tools.rumen.datatypes.DataType;
import org.apache.hadoop.tools.rumen.datatypes.util.JobPropertyParser;
import org.apache.hadoop.tools.rumen.datatypes.util.MapReduceJobPropertiesParser;
import org.apache.hadoop.tools.rumen.state.StatePool;
import org.apache.hadoop.util.ReflectionUtils;

public class JobProperties
implements AnonymizableDataType<Properties> {
    public static final String PARSERS_CONFIG_KEY = "rumen.datatypes.jobproperties.parsers";
    private final Properties jobProperties;

    public JobProperties() {
        this(new Properties());
    }

    public JobProperties(Properties properties) {
        this.jobProperties = properties;
    }

    public Properties getValue() {
        return this.jobProperties;
    }

    public Properties getAnonymizedValue(StatePool statePool, Configuration conf) {
        Properties filteredProperties = null;
        ArrayList<Object> pList = new ArrayList<Object>(1);
        String config = conf.get(PARSERS_CONFIG_KEY);
        if (config != null) {
            Class[] parsers;
            for (Class c : parsers = conf.getClasses(PARSERS_CONFIG_KEY, new Class[0])) {
                JobPropertyParser jobPropertyParser = (JobPropertyParser)ReflectionUtils.newInstance((Class)c, (Configuration)conf);
                pList.add(jobPropertyParser);
            }
        } else {
            MapReduceJobPropertiesParser parser = new MapReduceJobPropertiesParser();
            pList.add(parser);
        }
        if (this.jobProperties != null) {
            filteredProperties = new Properties();
            block1: for (Map.Entry<Object, Object> entry : this.jobProperties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                for (JobPropertyParser jobPropertyParser : pList) {
                    DataType pValue = jobPropertyParser.parseJobProperty(key, value);
                    if (pValue == null) continue;
                    filteredProperties.put(key, pValue);
                    continue block1;
                }
            }
        }
        return filteredProperties;
    }
}

