/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.LocalPortForwarder;
import ch.ethz.ssh2.LocalStreamForwarder;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.auth.AuthenticationManager;
import ch.ethz.ssh2.channel.ChannelManager;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;

public class Connection {
    private AuthenticationManager am;
    private boolean authenticated = false;
    private ChannelManager cm;
    private CryptoWishList cryptoWishList = new CryptoWishList();
    private DHGexParameters dhgexpara = new DHGexParameters();
    private String hostname;
    private int port;
    private TransportManager tm;
    public static final String identification = "Ganymed_build207";

    public Connection(String hostname) {
        this(hostname, 22);
    }

    public Connection(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public synchronized String[] getRemainingAuthMethods(String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("user may not be NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        return this.am.getRemainingMethods(user);
    }

    public synchronized boolean isAuthMethodAvailable(String user, String method) throws IOException {
        if (method == null) {
            throw new IllegalArgumentException("method may not be NULL!");
        }
        String[] methods = this.getRemainingAuthMethods(user);
        int i = 0;
        while (i < methods.length) {
            if (methods[i].compareTo(method) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized boolean isAuthenticationPartialSuccess() {
        if (this.am == null) {
            return false;
        }
        return this.am.getPartialSuccess();
    }

    public synchronized boolean isAuthenticationComplete() {
        return this.authenticated;
    }

    public synchronized boolean authenticateWithDSA(String user, String pem, String password) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        this.authenticated = this.am.authenticateDSA(user, pem, password);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String user, InteractiveCallback cb) throws IOException {
        return this.authenticateWithKeyboardInteractive(user, null, cb);
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String user, String[] submethods, InteractiveCallback cb) throws IOException {
        if (cb == null) {
            throw new IllegalArgumentException("Callback may not ne NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        this.authenticated = this.am.authenticateInteractive(user, submethods, cb);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPassword(String user, String pass) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        this.authenticated = this.am.authenticatePassword(user, pass);
        return this.authenticated;
    }

    public synchronized void close() {
        if (this.tm != null) {
            this.tm.close("Closed due to user request.");
            this.tm = null;
        }
        this.am = null;
        this.cm = null;
        this.authenticated = false;
    }

    public synchronized ConnectionInfo connect() throws IOException {
        return this.connect(null);
    }

    public synchronized ConnectionInfo connect(ServerHostKeyVerifier verifier) throws IOException {
        if (this.tm != null) {
            throw new IOException("Connection is already in connected state!");
        }
        try {
            this.tm = new TransportManager(this.hostname, this.port);
            this.tm.initialize(this.cryptoWishList, verifier, this.dhgexpara);
            return this.tm.getConnectionInfo(1);
        }
        catch (IOException e1) {
            this.close();
            throw new IOException(e1.getMessage());
        }
    }

    public synchronized void forceKeyExchange() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        this.tm.forceKeyExchange(this.cryptoWishList, this.dhgexpara);
    }

    public synchronized String[] getAvailableCiphers() {
        return BlockCipherFactory.getCipherList();
    }

    public synchronized String[] getAvailableMACs() {
        return MAC.getMacList();
    }

    public synchronized ConnectionInfo getConnectionInfo() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot get details of connection, you need to establish a connection first.");
        }
        return this.tm.getConnectionInfo(1);
    }

    public synchronized Session openSession() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot open session, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot open session, connection is not authenticated.");
        }
        return new Session(this.cm);
    }

    public synchronized SCPClient createSCPClient() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot create SCP client, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot create SCP client, connection is not authenticated.");
        }
        return new SCPClient(this);
    }

    public synchronized LocalPortForwarder createLocalPortForwarder(int local_port, String host_to_connect, int port_to_connect) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward ports, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward ports, connection is not authenticated.");
        }
        return new LocalPortForwarder(this.cm, local_port, host_to_connect, port_to_connect);
    }

    public synchronized LocalStreamForwarder createLocalStreamForwarder(String host_to_connect, int port_to_connect) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward, connection is not authenticated.");
        }
        return new LocalStreamForwarder(this.cm, host_to_connect, port_to_connect);
    }

    public synchronized void setDHGexParameters(DHGexParameters dgp) {
        if (dgp == null) {
            throw new IllegalArgumentException();
        }
        this.dhgexpara = dgp;
    }

    public synchronized void setClient2ServerCiphers(String[] ciphers) {
        if (ciphers == null) {
            throw new IllegalArgumentException();
        }
        BlockCipherFactory.checkCipherList(ciphers);
        this.cryptoWishList.c2s_enc_algos = ciphers;
    }

    public synchronized void setClient2ServerMACs(String[] macs) {
        if (macs == null) {
            throw new IllegalArgumentException();
        }
        MAC.checkMacList(macs);
        this.cryptoWishList.c2s_mac_algos = macs;
    }

    public synchronized void setServer2ClientCiphers(String[] ciphers) {
        if (ciphers == null) {
            throw new IllegalArgumentException();
        }
        BlockCipherFactory.checkCipherList(ciphers);
        this.cryptoWishList.s2c_enc_algos = ciphers;
    }

    public synchronized void setServer2ClientMACs(String[] macs) {
        if (macs == null) {
            throw new IllegalArgumentException();
        }
        MAC.checkMacList(macs);
        this.cryptoWishList.s2c_mac_algos = macs;
    }
}

