/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.auth;

import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.crypto.PEMDecoder;
import ch.ethz.ssh2.packets.PacketServiceAccept;
import ch.ethz.ssh2.packets.PacketServiceRequest;
import ch.ethz.ssh2.packets.PacketUserauthBanner;
import ch.ethz.ssh2.packets.PacketUserauthFailure;
import ch.ethz.ssh2.packets.PacketUserauthInfoRequest;
import ch.ethz.ssh2.packets.PacketUserauthInfoResponse;
import ch.ethz.ssh2.packets.PacketUserauthRequestInteractive;
import ch.ethz.ssh2.packets.PacketUserauthRequestNone;
import ch.ethz.ssh2.packets.PacketUserauthRequestPassword;
import ch.ethz.ssh2.packets.PacketUserauthRequestPublicKey;
import ch.ethz.ssh2.packets.TypesWriter;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.DSASignature;
import ch.ethz.ssh2.signature.DsaSha1Verify;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;
import java.util.Vector;

public class AuthenticationManager
implements MessageHandler {
    TransportManager tm;
    Vector packets = new Vector();
    boolean connectionClosed = false;
    String banner;
    String[] remainingMethods = null;
    boolean isPartialSuccess = false;
    boolean authenticated = false;
    boolean initDone = false;

    public AuthenticationManager(TransportManager tm) {
        this.tm = tm;
    }

    boolean methodPossible(String methName) {
        if (this.remainingMethods == null) {
            return false;
        }
        int i = 0;
        while (i < this.remainingMethods.length) {
            if (this.remainingMethods[i].compareTo(methName) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] deQueue() throws IOException {
        Vector vector = this.packets;
        synchronized (vector) {
            while (true) {
                if (this.packets.size() != 0) {
                    byte[] res = (byte[])this.packets.firstElement();
                    this.packets.removeElementAt(0);
                    return res;
                }
                if (this.connectionClosed) {
                    throw new IOException("Connection closed. (" + this.tm.getReasonClosed() + ")");
                }
                try {
                    this.packets.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    byte[] getNextMessage() throws IOException {
        byte[] msg;
        while ((msg = this.deQueue())[0] == 53) {
            PacketUserauthBanner sb = new PacketUserauthBanner(msg, 0, msg.length);
            this.banner = sb.getBanner();
        }
        return msg;
    }

    public String[] getRemainingMethods(String user) throws IOException {
        this.initialize(user);
        return this.remainingMethods;
    }

    public boolean getPartialSuccess() {
        return this.isPartialSuccess;
    }

    private boolean initialize(String user) throws IOException {
        if (!this.initDone) {
            this.tm.registerMessageHandler(this, 0, 255);
            PacketServiceRequest sr = new PacketServiceRequest("ssh-userauth");
            this.tm.sendMessage(sr.getPayload());
            PacketUserauthRequestNone urn = new PacketUserauthRequestNone("ssh-connection", user);
            this.tm.sendMessage(urn.getPayload());
            byte[] msg = this.getNextMessage();
            new PacketServiceAccept(msg, 0, msg.length);
            msg = this.getNextMessage();
            this.initDone = true;
            if (msg[0] == 52) {
                this.authenticated = true;
                return true;
            }
            if (msg[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(msg, 0, msg.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                this.isPartialSuccess = puf.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + msg[0] + ")");
        }
        return this.authenticated;
    }

    public boolean authenticateDSA(String user, String PEMPrivateDSAKey, String password) throws IOException {
        try {
            this.initialize(user);
            if (!this.methodPossible("publickey")) {
                throw new IOException("Authentication method publickey not supported by the server at this stage.");
            }
            DSAPrivateKey pk = PEMDecoder.decode(PEMPrivateDSAKey, password);
            byte[] pk_enc = DsaSha1Verify.encodeDSAPublicKey(pk.getPublicKey());
            TypesWriter tw = new TypesWriter();
            byte[] H = this.tm.getSessionIdentifier();
            tw.writeString(H, 0, H.length);
            tw.writeByte(50);
            tw.writeString(user);
            tw.writeString("ssh-connection");
            tw.writeString("publickey");
            tw.writeBoolean(true);
            tw.writeString("ssh-dss");
            tw.writeString(pk_enc, 0, pk_enc.length);
            byte[] msg = new byte[tw.length()];
            tw.getBytes(msg);
            DSASignature ds = DsaSha1Verify.generateSignature(msg, pk);
            byte[] ds_enc = DsaSha1Verify.encodeDSASignature(ds);
            PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user, "ssh-dss", pk_enc, ds_enc);
            this.tm.sendMessage(ua.getPayload());
            byte[] ar = this.getNextMessage();
            if (ar[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (ar[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                this.isPartialSuccess = puf.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
        }
        catch (IOException e) {
            this.tm.close(e.getMessage());
            throw e;
        }
    }

    public boolean authenticatePassword(String user, String pass) throws IOException {
        try {
            this.initialize(user);
            if (!this.methodPossible("password")) {
                throw new IOException("Authentication method password not supported by the server at this stage.");
            }
            PacketUserauthRequestPassword ua = new PacketUserauthRequestPassword("ssh-connection", user, pass);
            this.tm.sendMessage(ua.getPayload());
            byte[] ar = this.getNextMessage();
            if (ar[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (ar[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                this.isPartialSuccess = puf.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
        }
        catch (IOException e) {
            this.tm.close(e.getMessage());
            throw e;
        }
    }

    public boolean authenticateInteractive(String user, String[] submethods, InteractiveCallback cb) throws IOException {
        try {
            byte[] ar;
            this.initialize(user);
            if (!this.methodPossible("keyboard-interactive")) {
                throw new IOException("Authentication method keyboard-interactive not supported by the server at this stage.");
            }
            if (submethods == null) {
                submethods = new String[]{};
            }
            PacketUserauthRequestInteractive ua = new PacketUserauthRequestInteractive("ssh-connection", user, submethods);
            this.tm.sendMessage(ua.getPayload());
            while (true) {
                if ((ar = this.getNextMessage())[0] == 52) {
                    this.authenticated = true;
                    this.tm.removeMessageHandler(this, 0, 255);
                    return true;
                }
                if (ar[0] == 51) {
                    PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                    this.remainingMethods = puf.getAuthThatCanContinue();
                    this.isPartialSuccess = puf.isPartialSuccess();
                    return false;
                }
                if (ar[0] != 60) break;
                PacketUserauthInfoRequest pui = new PacketUserauthInfoRequest(ar, 0, ar.length);
                String[] responses = cb.replyToChallenge(pui.getName(), pui.getInstruction(), pui.getNumPrompts(), pui.getPrompt(), pui.getEcho());
                if (responses == null) {
                    throw new IOException("Your callback may not return NULL!");
                }
                PacketUserauthInfoResponse puir = new PacketUserauthInfoResponse(responses);
                this.tm.sendMessage(puir.getPayload());
            }
            throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
        }
        catch (IOException e) {
            this.tm.close(e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(byte[] msg, int msglen) throws IOException {
        Vector vector = this.packets;
        synchronized (vector) {
            if (msg == null) {
                this.connectionClosed = true;
            } else {
                byte[] tmp = new byte[msglen];
                System.arraycopy(msg, 0, tmp, 0, msglen);
                this.packets.addElement(tmp);
            }
            this.packets.notifyAll();
            if (this.packets.size() > 5) {
                this.connectionClosed = true;
                throw new IOException("Error, peer is flooding us with authentication packets.");
            }
        }
    }
}

