/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.log.Logger;
import java.io.IOException;
import java.io.InputStream;

public final class ChannelInputStream
extends InputStream {
    private static final Logger log;
    Channel c;
    boolean isClosed = false;
    boolean isEOF = false;
    boolean extendedFlag = false;
    byte[] buffer = new byte[30000];
    int bufferpos = 0;
    int bufferlen = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.ethz.ssh2.channel.ChannelInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    ChannelInputStream(Channel c, boolean isExtended) {
        this.c = c;
        this.extendedFlag = isExtended;
    }

    private void fillBuffer() throws IOException {
        this.bufferpos = 0;
        this.bufferlen = 0;
        if (this.isEOF) {
            if (log.isEnabled()) {
                log.log(80, "fillBuffer: EOF");
            }
            return;
        }
        this.bufferlen = this.c.cm.getChannelData(this.c, this.extendedFlag, this.buffer);
        if (log.isEnabled()) {
            log.log(80, "fillBuffer: getChannelData=" + this.bufferlen);
        }
        if (this.bufferlen == 0) {
            this.isEOF = true;
            return;
        }
    }

    public int available() throws IOException {
        if (this.bufferlen > 0) {
            return this.bufferlen;
        }
        if (this.isEOF) {
            return 0;
        }
        int avail = this.c.cm.getAvailable(this.c, this.extendedFlag);
        return avail > 0 ? avail : 0;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bufferlen == 0) {
            this.fillBuffer();
            if (this.isEOF) {
                return -1;
            }
        }
        int ret = this.bufferlen >= len ? len : this.bufferlen;
        System.arraycopy(this.buffer, this.bufferpos, b, off, ret);
        this.bufferpos += ret;
        this.bufferlen -= ret;
        return ret;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        if (this.bufferlen == 0) {
            this.fillBuffer();
            if (this.isEOF) {
                return -1;
            }
        }
        --this.bufferlen;
        return this.buffer[this.bufferpos++] & 0xFF;
    }
}

