/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelManager;
import ch.ethz.ssh2.channel.LocalForwarder;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class LocalAcceptThread
extends Thread {
    ChannelManager cm;
    int local_port;
    String host_to_connect;
    int port_to_connect;
    ServerSocket ss;

    public LocalAcceptThread(ChannelManager cm, int local_port, String host_to_connect, int port_to_connect) {
        this.cm = cm;
        this.local_port = local_port;
        this.host_to_connect = host_to_connect;
        this.port_to_connect = port_to_connect;
    }

    public void stopListening() {
        try {
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run() {
        try {
            this.ss = new ServerSocket(this.local_port);
            this.cm.registerThread(this);
            while (true) {
                Socket s = this.ss.accept();
                Channel cn = this.cm.createDirectTCPIPChannel(this.host_to_connect, this.port_to_connect, s.getInetAddress().getHostAddress(), s.getPort());
                new LocalForwarder(cn.stdoutStream, s.getOutputStream(), "RemoteToLocal").start();
                new LocalForwarder(s.getInputStream(), cn.stdinStream, "LocalToRemote").start();
            }
        }
        catch (IOException e) {
            try {
                if (this.ss != null) {
                    this.ss.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }
}

