/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto;

import ch.ethz.ssh2.crypto.Base64;
import ch.ethz.ssh2.crypto.SimpleDERReader;
import ch.ethz.ssh2.crypto.cipher.CBCMode;
import ch.ethz.ssh2.crypto.cipher.DESede;
import ch.ethz.ssh2.crypto.digest.MD5;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;

public class PEMDecoder {
    private static int hexToInt(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new IllegalArgumentException("Need hex char");
    }

    private static byte[] hexToByteArray(String hex) {
        if (hex == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Uneven string length in hex encoding.");
        }
        byte[] decoded = new byte[hex.length() / 2];
        int i = 0;
        while (i < decoded.length) {
            int hi = PEMDecoder.hexToInt(hex.charAt(i * 2));
            int lo = PEMDecoder.hexToInt(hex.charAt(i * 2 + 1));
            decoded[i] = (byte)(hi * 16 + lo);
            ++i;
        }
        return decoded;
    }

    private static byte[] generateKeyFromPasswordSaltWithMD5(byte[] password, byte[] salt, int keyLen) throws IOException {
        MD5 md5 = new MD5();
        byte[] key = new byte[keyLen];
        byte[] tmp = new byte[md5.getDigestLength()];
        while (true) {
            md5.update(password, 0, password.length);
            md5.update(salt, 0, salt.length);
            int copy = keyLen < tmp.length ? keyLen : tmp.length;
            md5.digest(tmp, 0);
            System.arraycopy(tmp, 0, key, key.length - keyLen, copy);
            if ((keyLen -= copy) == 0) {
                return key;
            }
            md5.update(tmp, 0, tmp.length);
        }
    }

    private static byte[] removePadding(byte[] buff, int blockSize) throws IOException {
        int rfc_1423_padding = buff[buff.length - 1] & 0xFF;
        if (rfc_1423_padding < 1 || rfc_1423_padding > blockSize) {
            throw new IOException("Decrypted PEM has wrong padding, did you specify the correct password?");
        }
        int i = 2;
        while (i <= rfc_1423_padding) {
            if (buff[buff.length - i] != rfc_1423_padding) {
                throw new IOException("Decrypted PEM has wrong padding, did you specify the correct password?");
            }
            ++i;
        }
        byte[] tmp = new byte[buff.length - rfc_1423_padding];
        System.arraycopy(buff, 0, tmp, 0, buff.length - rfc_1423_padding);
        return tmp;
    }

    public static DSAPrivateKey decode(String t, String password) throws IOException {
        String line;
        boolean isEncrypted = false;
        byte[] salt = null;
        int blockSize = 0;
        StringBuffer keyData = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(t));
        do {
            if ((line = br.readLine()) != null) continue;
            throw new IOException("Invalid PEM structure, 'BEGIN DSA...' missing");
        } while (line.indexOf("-----BEGIN DSA PRIVATE KEY-----") == -1);
        while (true) {
            if ((line = br.readLine()) == null) {
                throw new IOException("Invalid PEM structure, 'END DSA...' missing");
            }
            if (line.indexOf("-----END DSA PRIVATE KEY-----") != -1) break;
            if (line.indexOf("Proc-Type: 4,ENCRYPTED") != -1) {
                isEncrypted = true;
                continue;
            }
            if (line.indexOf("DEK-Info:") != -1) {
                String dekInfo = "DEK-Info: DES-EDE3-CBC,";
                int dek_idx = line.indexOf(dekInfo);
                if (dek_idx == -1) {
                    throw new IOException("Unknown PEM encryption");
                }
                blockSize = 8;
                String saltString = line.substring(dek_idx + dekInfo.length()).trim();
                if (saltString.length() != 16) {
                    throw new IOException("Broken DEK Info in PEM");
                }
                salt = PEMDecoder.hexToByteArray(saltString);
                continue;
            }
            keyData.append(line.trim());
        }
        t = keyData.toString();
        byte[] z = Base64.decode(t);
        if (z.length == 0) {
            throw new IOException("Invalid PEM structure");
        }
        if (isEncrypted) {
            if (z.length % blockSize != 0) {
                throw new IOException("Invalid PEM structure");
            }
            if (salt == null) {
                throw new IOException("Broken PEM, no mode and salt given, but encryption enabled");
            }
            if (password == null) {
                throw new IOException("This private key is encrypted, you need to specify a password");
            }
            byte[] pwd_bytes = password.getBytes();
            int keyLen = 24;
            byte[] key = PEMDecoder.generateKeyFromPasswordSaltWithMD5(pwd_bytes, salt, keyLen);
            DESede des3 = new DESede();
            des3.init(false, key);
            CBCMode cbc = new CBCMode(des3, salt, false);
            byte[] dz = new byte[z.length];
            int i = 0;
            while (i < z.length / blockSize) {
                cbc.transformBlock(z, i * blockSize, dz, i * blockSize);
                ++i;
            }
            z = PEMDecoder.removePadding(dz, blockSize);
        }
        SimpleDERReader dr = new SimpleDERReader(z);
        byte[] seq = dr.readSequenceAsByteArray();
        if (dr.available() != 0) {
            throw new IOException("Padding in DSA PRIVATE KEY DER stream.");
        }
        dr.resetInput(seq);
        BigInteger version = dr.readInt();
        if (version.compareTo(BigInteger.ZERO) != 0) {
            throw new IOException("Wrong version (" + version + ") in DSA PRIVATE KEY DER stream.");
        }
        BigInteger p = dr.readInt();
        BigInteger q = dr.readInt();
        BigInteger g = dr.readInt();
        BigInteger y = dr.readInt();
        BigInteger x = dr.readInt();
        if (dr.available() != 0) {
            throw new IOException("Padding in DSA PRIVATE KEY DER stream.");
        }
        return new DSAPrivateKey(p, q, g, y, x);
    }
}

