/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.dh;

import ch.ethz.ssh2.crypto.digest.HashForSSH2Types;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DhExchange {
    static final BigInteger p;
    static final BigInteger g;
    BigInteger e;
    BigInteger x;
    BigInteger f;
    BigInteger k;

    static {
        String p_string = "179769313486231590770839156793787453197860296048756011706444423684197180216158519368947833795864925541502180565485980503646440548199239100050792877003355816639229553136239076508735759914822574862575007425302077447712589550957937778424442426617334727629299387668709205606050270810842907692932019128194467627007";
        p = new BigInteger("179769313486231590770839156793787453197860296048756011706444423684197180216158519368947833795864925541502180565485980503646440548199239100050792877003355816639229553136239076508735759914822574862575007425302077447712589550957937778424442426617334727629299387668709205606050270810842907692932019128194467627007");
        g = new BigInteger("2");
    }

    public void init() {
        this.k = null;
        this.x = new BigInteger(p.bitLength() - 1, new SecureRandom());
        this.e = g.modPow(this.x, p);
    }

    public BigInteger getE() {
        if (this.e == null) {
            throw new IllegalStateException("DhDsaExchange not initialized!");
        }
        return this.e;
    }

    public BigInteger getK() {
        if (this.k == null) {
            throw new IllegalStateException("Shared secret not yet known, need f first!");
        }
        return this.k;
    }

    public void setF(BigInteger f) {
        if (this.e == null) {
            throw new IllegalStateException("DhDsaExchange not initialized!");
        }
        BigInteger zero = BigInteger.valueOf(0L);
        if (zero.compareTo(f) >= 0 || p.compareTo(f) <= 0) {
            throw new IllegalArgumentException("Invalid f specified!");
        }
        this.f = f;
        this.k = f.modPow(this.x, p);
    }

    public byte[] calculateH(byte[] clientversion, byte[] serverversion, byte[] clientKexPayload, byte[] serverKexPayload, byte[] hostKey) {
        HashForSSH2Types hash = new HashForSSH2Types("SHA");
        hash.updateByteString(clientversion);
        hash.updateByteString(serverversion);
        hash.updateByteString(clientKexPayload);
        hash.updateByteString(serverKexPayload);
        hash.updateByteString(hostKey);
        hash.updateBigInt(this.e);
        hash.updateBigInt(this.f);
        hash.updateBigInt(this.k);
        return hash.getDigest();
    }
}

