/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.digest;

import ch.ethz.ssh2.crypto.digest.Digest;

public class SHA1
implements Digest {
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private final byte[] msg = new byte[64];
    private final int[] w = new int[80];
    private int pos;
    private long len;

    public SHA1() {
        this.reset();
    }

    public final int getDigestLength() {
        return 20;
    }

    public void reset() {
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
        this.pos = 0;
        this.len = 0L;
    }

    public final void update(byte[] b, int off, int len) {
        int i = off;
        while (i < off + len) {
            this.update(b[i]);
            ++i;
        }
    }

    public final void update(byte[] b) {
        int i = 0;
        while (i < b.length) {
            this.update(b[i]);
            ++i;
        }
    }

    public final void update(byte b) {
        this.msg[this.pos++] = b;
        this.len += 8L;
        if (this.pos == 64) {
            this.perform();
            this.pos = 0;
        }
    }

    private static final String toHexString(byte[] b) {
        String hexChar = "0123456789ABCDEF";
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            sb.append("0123456789ABCDEF".charAt(b[i] >> 4 & 0xF));
            sb.append("0123456789ABCDEF".charAt(b[i] & 0xF));
            ++i;
        }
        return sb.toString();
    }

    private final void putInt(byte[] b, int pos, int val) {
        b[pos] = (byte)(val >> 24);
        b[pos + 1] = (byte)(val >> 16);
        b[pos + 2] = (byte)(val >> 8);
        b[pos + 3] = (byte)val;
    }

    public final void digest(byte[] out) {
        this.digest(out, 0);
    }

    public final void digest(byte[] out, int off) {
        long l = this.len;
        this.update((byte)-128);
        while (this.pos != 56) {
            this.update((byte)0);
        }
        this.update((byte)(l >> 56));
        this.update((byte)(l >> 48));
        this.update((byte)(l >> 40));
        this.update((byte)(l >> 32));
        this.update((byte)(l >> 24));
        this.update((byte)(l >> 16));
        this.update((byte)(l >> 8));
        this.update((byte)l);
        this.putInt(out, off, this.H0);
        this.putInt(out, off + 4, this.H1);
        this.putInt(out, off + 8, this.H2);
        this.putInt(out, off + 12, this.H3);
        this.putInt(out, off + 16, this.H4);
        this.reset();
    }

    private final void perform() {
        int T;
        int i = 0;
        while (i < 16) {
            this.w[i] = (this.msg[i * 4] & 0xFF) << 24 | (this.msg[i * 4 + 1] & 0xFF) << 16 | (this.msg[i * 4 + 2] & 0xFF) << 8 | this.msg[i * 4 + 3] & 0xFF;
            ++i;
        }
        int t = 16;
        while (t < 80) {
            int x = this.w[t - 3] ^ this.w[t - 8] ^ this.w[t - 14] ^ this.w[t - 16];
            this.w[t] = x << 1 | x >>> 31;
            ++t;
        }
        int A = this.H0;
        int B = this.H1;
        int C = this.H2;
        int D = this.H3;
        int E = this.H4;
        int t2 = 0;
        while (t2 <= 19) {
            T = (A << 5 | A >>> 27) + (B & C | ~B & D) + E + this.w[t2] + 1518500249;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = T;
            ++t2;
        }
        t2 = 20;
        while (t2 <= 39) {
            T = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + this.w[t2] + 1859775393;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = T;
            ++t2;
        }
        t2 = 40;
        while (t2 <= 59) {
            T = (A << 5 | A >>> 27) + (B & C | B & D | C & D) + E + this.w[t2] + -1894007588;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = T;
            ++t2;
        }
        t2 = 60;
        while (t2 <= 79) {
            T = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + this.w[t2] + -899497514;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = T;
            ++t2;
        }
        this.H0 += A;
        this.H1 += B;
        this.H2 += C;
        this.H3 += D;
        this.H4 += E;
    }

    public static void main(String[] args) {
        SHA1 sha = new SHA1();
        byte[] dig1 = new byte[20];
        byte[] dig2 = new byte[20];
        byte[] dig3 = new byte[20];
        sha.update("abc".getBytes());
        sha.digest(dig1);
        sha.update("abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq".getBytes());
        sha.digest(dig2);
        int i = 0;
        while (i < 1000000) {
            sha.update((byte)97);
            ++i;
        }
        sha.digest(dig3);
        String dig1_res = SHA1.toHexString(dig1);
        String dig2_res = SHA1.toHexString(dig2);
        String dig3_res = SHA1.toHexString(dig3);
        String dig1_ref = "A9993E364706816ABA3E25717850C26C9CD0D89D";
        String dig2_ref = "84983E441C3BD26EBAAE4AA1F95129E5E54670F1";
        String dig3_ref = "34AA973CD4C4DAA4F61EEB2BDBAD27316534016F";
        if (dig1_res.equals(dig1_ref)) {
            System.out.println("SHA-1 Test 1 OK.");
        } else {
            System.out.println("SHA-1 Test 1 FAILED.");
        }
        if (dig2_res.equals(dig2_ref)) {
            System.out.println("SHA-1 Test 2 OK.");
        } else {
            System.out.println("SHA-1 Test 2 FAILED.");
        }
        if (dig3_res.equals(dig3_ref)) {
            System.out.println("SHA-1 Test 3 OK.");
        } else {
            System.out.println("SHA-1 Test 3 FAILED.");
        }
    }
}

