/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.signature;

import ch.ethz.ssh2.crypto.digest.SHA1;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.DSAPublicKey;
import ch.ethz.ssh2.signature.DSASignature;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DsaSha1Verify {
    public static DSAPublicKey decodeDSAPublicKey(byte[] key) throws IOException {
        TypesReader tr = new TypesReader(key);
        String key_format = tr.readString();
        if (!key_format.equals("ssh-dss")) {
            throw new IllegalArgumentException("This is not a ssh-dss public host key");
        }
        BigInteger p = tr.readMPINT();
        BigInteger q = tr.readMPINT();
        BigInteger g = tr.readMPINT();
        BigInteger y = tr.readMPINT();
        if (tr.remain() != 0) {
            throw new IOException("Padding in DSA public key!");
        }
        return new DSAPublicKey(p, q, g, y);
    }

    public static byte[] encodeDSAPublicKey(DSAPublicKey pk) throws IOException {
        TypesWriter tw = new TypesWriter();
        tw.writeString("ssh-dss");
        tw.writeMPInt(pk.getP());
        tw.writeMPInt(pk.getQ());
        tw.writeMPInt(pk.getG());
        tw.writeMPInt(pk.getY());
        byte[] enc = new byte[tw.length()];
        tw.getBytes(enc);
        return enc;
    }

    public static byte[] encodeDSASignature(DSASignature ds) {
        TypesWriter tw = new TypesWriter();
        tw.writeString("ssh-dss");
        byte[] r = ds.getR().toByteArray();
        byte[] s = ds.getS().toByteArray();
        byte[] a40 = new byte[40];
        int r_copylen = r.length < 20 ? r.length : 20;
        int s_copylen = s.length < 20 ? s.length : 20;
        System.arraycopy(r, r.length - r_copylen, a40, 20 - r_copylen, r_copylen);
        System.arraycopy(s, s.length - s_copylen, a40, 40 - s_copylen, s_copylen);
        tw.writeString(a40, 0, 40);
        byte[] enc = new byte[tw.length()];
        tw.getBytes(enc);
        return enc;
    }

    public static DSASignature decodeDSASignature(byte[] sig) throws IOException {
        TypesReader tr = new TypesReader(sig);
        String sig_format = tr.readString();
        if (!sig_format.equals("ssh-dss")) {
            throw new IOException("Peer sent wrong signature format");
        }
        byte[] rsArray = tr.readByteString();
        if (rsArray.length != 40) {
            throw new IOException("Peer sent corrupt signature");
        }
        if (tr.remain() != 0) {
            throw new IOException("Padding in DSA signature!");
        }
        byte[] tmp = new byte[21];
        System.arraycopy(rsArray, 0, tmp, 1, 20);
        BigInteger r = new BigInteger(tmp);
        System.arraycopy(rsArray, 20, tmp, 1, 20);
        BigInteger s = new BigInteger(tmp);
        return new DSASignature(r, s);
    }

    public static boolean verifySignature(byte[] message, DSASignature ds, DSAPublicKey dpk) throws IOException {
        SHA1 md = new SHA1();
        md.update(message);
        byte[] sha_message = new byte[md.getDigestLength()];
        md.digest(sha_message);
        BigInteger m = new BigInteger(1, sha_message);
        BigInteger r = ds.getR();
        BigInteger s = ds.getS();
        BigInteger g = dpk.getG();
        BigInteger p = dpk.getP();
        BigInteger q = dpk.getQ();
        BigInteger y = dpk.getY();
        BigInteger zero = BigInteger.ZERO;
        if (zero.compareTo(r) >= 0 || q.compareTo(r) <= 0) {
            return false;
        }
        if (zero.compareTo(s) >= 0 || q.compareTo(s) <= 0) {
            return false;
        }
        BigInteger w = s.modInverse(q);
        BigInteger u1 = m.multiply(w).mod(q);
        BigInteger u2 = r.multiply(w).mod(q);
        u1 = g.modPow(u1, p);
        u2 = y.modPow(u2, p);
        BigInteger v = u1.multiply(u2).mod(p).mod(q);
        return v.equals(r);
    }

    public static DSASignature generateSignature(byte[] message, DSAPrivateKey pk) {
        BigInteger k;
        SHA1 md = new SHA1();
        md.update(message);
        byte[] sha_message = new byte[md.getDigestLength()];
        md.digest(sha_message);
        BigInteger m = new BigInteger(1, sha_message);
        int qBitLength = pk.getQ().bitLength();
        while ((k = new BigInteger(qBitLength, new SecureRandom())).compareTo(pk.getQ()) >= 0) {
        }
        BigInteger r = pk.getG().modPow(k, pk.getP()).mod(pk.getQ());
        k = k.modInverse(pk.getQ()).multiply(m.add(pk.getX().multiply(r)));
        BigInteger s = k.mod(pk.getQ());
        return new DSASignature(r, s);
    }
}

