/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.signature;

import ch.ethz.ssh2.crypto.SimpleDERReader;
import ch.ethz.ssh2.crypto.digest.SHA1;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.signature.RSAPublicKey;
import java.io.IOException;
import java.math.BigInteger;

public class RSASha1Verify {
    public static RSAPublicKey parseRSAPublicKey(byte[] key) throws IOException {
        TypesReader tr = new TypesReader(key);
        String key_format = tr.readString();
        if (!key_format.equals("ssh-rsa")) {
            throw new IllegalArgumentException("This is not a ssh-rsa public host key");
        }
        BigInteger e = tr.readMPINT();
        BigInteger n = tr.readMPINT();
        if (tr.remain() != 0) {
            throw new IOException("Padding in RSA public key!");
        }
        return new RSAPublicKey(e, n);
    }

    public static RSASignature parseRSASignature(byte[] sig) throws IOException {
        TypesReader tr = new TypesReader(sig);
        String sig_format = tr.readString();
        if (!sig_format.equals("ssh-rsa")) {
            throw new IOException("Peer sent wrong signature format");
        }
        byte[] rsArray = tr.readByteString();
        if (tr.remain() != 0) {
            throw new IOException("Padding in RSA signature!");
        }
        byte[] tmp = new byte[rsArray.length + 1];
        System.arraycopy(rsArray, 0, tmp, 1, rsArray.length);
        BigInteger s = new BigInteger(tmp);
        return new RSASignature(s);
    }

    public static boolean verifySignature(byte[] message, byte[] sshRsaSig, byte[] sshRsaHostKey) throws IOException {
        RSAPublicKey dpk = RSASha1Verify.parseRSAPublicKey(sshRsaHostKey);
        RSASignature ds = RSASha1Verify.parseRSASignature(sshRsaSig);
        SHA1 md = new SHA1();
        md.update(message);
        byte[] sha_message = new byte[md.getDigestLength()];
        md.digest(sha_message);
        BigInteger n = dpk.getN();
        BigInteger e = dpk.getE();
        BigInteger s = ds.getS();
        if (BigInteger.ZERO.compareTo(s) >= 0 || n.compareTo(s) <= 0) {
            return false;
        }
        byte[] v = s.modPow(e, n).toByteArray();
        if (v.length <= 10) {
            return false;
        }
        int pos = 0;
        if (v[0] == 0) {
            ++pos;
        }
        if (v[pos] != 1 && v[pos] != 2) {
            return false;
        }
        ++pos;
        while (pos < v.length && v[pos] != 0) {
            ++pos;
        }
        if (++pos < 10 || pos >= v.length) {
            return false;
        }
        SimpleDERReader dr = new SimpleDERReader(v, pos, v.length - pos);
        byte[] seq = dr.readSequenceAsByteArray();
        dr.resetInput(seq);
        dr.readSequenceAsByteArray();
        byte[] digest = dr.readOctetString();
        if (digest.length != sha_message.length) {
            return false;
        }
        int i = 0;
        while (i < sha_message.length) {
            if (sha_message[i] != digest[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static class RSASignature {
        private BigInteger s;

        public BigInteger getS() {
            return this.s;
        }

        public RSASignature(BigInteger s) {
            this.s = s;
        }
    }
}

