/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.KeyMaterial;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.dh.DhExchange;
import ch.ethz.ssh2.crypto.dh.DhGroupExchange;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.packets.PacketKexDHInit;
import ch.ethz.ssh2.packets.PacketKexDHReply;
import ch.ethz.ssh2.packets.PacketKexDhGexGroup;
import ch.ethz.ssh2.packets.PacketKexDhGexInit;
import ch.ethz.ssh2.packets.PacketKexDhGexReply;
import ch.ethz.ssh2.packets.PacketKexDhGexRequest;
import ch.ethz.ssh2.packets.PacketKexInit;
import ch.ethz.ssh2.packets.PacketNewKeys;
import ch.ethz.ssh2.signature.DSAPublicKey;
import ch.ethz.ssh2.signature.DSASignature;
import ch.ethz.ssh2.signature.DsaSha1Verify;
import ch.ethz.ssh2.signature.RSASha1Verify;
import ch.ethz.ssh2.transport.ClientServerHello;
import ch.ethz.ssh2.transport.KexParameters;
import ch.ethz.ssh2.transport.KexState;
import ch.ethz.ssh2.transport.NegotiateException;
import ch.ethz.ssh2.transport.NegotiatedParameters;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;

public class KexManager {
    KexState kxs;
    int kexCount = 0;
    KeyMaterial km;
    byte[] sessionId;
    ClientServerHello csh;
    Object accessLock = new Object();
    ConnectionInfo lastConnInfo = null;
    boolean connectionClosed = false;
    boolean ignore_next_kex_packet = false;
    TransportManager tm;
    CryptoWishList nextKEXcryptoWishList;
    DHGexParameters nextKEXdhgexParameters;
    ServerHostKeyVerifier verifier;
    String hostname;
    int port;

    public KexManager(TransportManager tm, ClientServerHello csh, CryptoWishList initialCwl, String hostname, int port, ServerHostKeyVerifier keyVerifier) {
        this.tm = tm;
        this.csh = csh;
        this.nextKEXcryptoWishList = initialCwl;
        this.nextKEXdhgexParameters = new DHGexParameters();
        this.hostname = hostname;
        this.port = port;
        this.verifier = keyVerifier;
    }

    public ConnectionInfo getOrWaitForConnectionInfo(int kexCount) throws IOException {
        Object object = this.accessLock;
        synchronized (object) {
            block5: while (true) {
                while (true) {
                    if (this.lastConnInfo != null && this.lastConnInfo.keyExchangeCounter >= kexCount) {
                        return this.lastConnInfo;
                    }
                    if (this.connectionClosed) {
                        throw new IOException("Connection closed (" + this.tm.getReasonClosed() + ")");
                    }
                    try {
                        this.accessLock.wait();
                        continue block5;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private String getFirstMatch(String[] client, String[] server) throws NegotiateException {
        if (client == null || server == null) {
            throw new IllegalArgumentException();
        }
        if (client.length == 0) {
            return null;
        }
        int i = 0;
        while (i < client.length) {
            int j = 0;
            while (j < server.length) {
                if (client[i].equals(server[j])) {
                    return client[i];
                }
                ++j;
            }
            ++i;
        }
        throw new NegotiateException();
    }

    private boolean compareFirstOfNameList(String[] a, String[] b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException();
        }
        if (a.length == 0 && b.length == 0) {
            return true;
        }
        if (a.length == 0 || b.length == 0) {
            return false;
        }
        return a[0].equals(b[0]);
    }

    private boolean isGuessOK(KexParameters cpar, KexParameters spar) {
        if (cpar == null || spar == null) {
            throw new IllegalArgumentException();
        }
        if (!this.compareFirstOfNameList(cpar.kex_algorithms, spar.kex_algorithms)) {
            return false;
        }
        return this.compareFirstOfNameList(cpar.server_host_key_algorithms, spar.server_host_key_algorithms);
    }

    private NegotiatedParameters mergeKexParameters(KexParameters client, KexParameters server) {
        NegotiatedParameters np = new NegotiatedParameters();
        try {
            np.kex_algo = this.getFirstMatch(client.kex_algorithms, server.kex_algorithms);
            np.server_host_key_algo = this.getFirstMatch(client.server_host_key_algorithms, server.server_host_key_algorithms);
            np.enc_algo_client_to_server = this.getFirstMatch(client.encryption_algorithms_client_to_server, server.encryption_algorithms_client_to_server);
            np.enc_algo_server_to_client = this.getFirstMatch(client.encryption_algorithms_server_to_client, server.encryption_algorithms_server_to_client);
            np.mac_algo_client_to_server = this.getFirstMatch(client.mac_algorithms_client_to_server, server.mac_algorithms_client_to_server);
            np.mac_algo_server_to_client = this.getFirstMatch(client.mac_algorithms_server_to_client, server.mac_algorithms_server_to_client);
            np.comp_algo_client_to_server = this.getFirstMatch(client.compression_algorithms_client_to_server, server.compression_algorithms_client_to_server);
            np.comp_algo_server_to_client = this.getFirstMatch(client.compression_algorithms_server_to_client, server.compression_algorithms_server_to_client);
        }
        catch (NegotiateException e) {
            return null;
        }
        try {
            np.lang_client_to_server = this.getFirstMatch(client.languages_client_to_server, server.languages_client_to_server);
        }
        catch (NegotiateException e1) {
            np.lang_client_to_server = null;
        }
        try {
            np.lang_server_to_client = this.getFirstMatch(client.languages_server_to_client, server.languages_server_to_client);
        }
        catch (NegotiateException e2) {
            np.lang_server_to_client = null;
        }
        if (this.isGuessOK(client, server)) {
            np.guessOK = true;
        }
        return np;
    }

    public synchronized void initiateKEX(CryptoWishList cwl, DHGexParameters dhgex) throws IOException {
        this.nextKEXcryptoWishList = cwl;
        this.nextKEXdhgexParameters = dhgex;
        if (this.kxs == null) {
            PacketKexInit kp;
            this.kxs = new KexState();
            this.kxs.dhgexParameters = this.nextKEXdhgexParameters;
            this.kxs.localKEX = kp = new PacketKexInit(this.nextKEXcryptoWishList);
            this.tm.sendKexMessage(kp.getPayload());
        }
    }

    private boolean establishKeyMaterial() {
        try {
            int mac_cs_key_len = MAC.getKeyLen(this.kxs.np.mac_algo_client_to_server);
            int enc_cs_key_len = BlockCipherFactory.getKeySize(this.kxs.np.enc_algo_client_to_server);
            int enc_cs_block_len = BlockCipherFactory.getBlockSize(this.kxs.np.enc_algo_client_to_server);
            int mac_sc_key_len = MAC.getKeyLen(this.kxs.np.mac_algo_server_to_client);
            int enc_sc_key_len = BlockCipherFactory.getKeySize(this.kxs.np.enc_algo_server_to_client);
            int enc_sc_block_len = BlockCipherFactory.getBlockSize(this.kxs.np.enc_algo_server_to_client);
            this.km = KeyMaterial.create("SHA", this.kxs.H, this.kxs.K, this.sessionId, enc_cs_key_len, enc_cs_block_len, mac_cs_key_len, enc_sc_key_len, enc_sc_block_len, mac_sc_key_len);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private void finishKex() throws IOException {
        MAC mac;
        BlockCipher cbc;
        if (this.sessionId == null) {
            this.sessionId = this.kxs.H;
        }
        this.establishKeyMaterial();
        PacketNewKeys ign = new PacketNewKeys();
        this.tm.sendKexMessage(ign.getPayload());
        try {
            cbc = BlockCipherFactory.createCipher(this.kxs.np.enc_algo_client_to_server, true, this.km.enc_key_client_to_server, this.km.initial_iv_client_to_server);
            mac = new MAC(this.kxs.np.mac_algo_client_to_server, this.km.integrity_key_client_to_server);
        }
        catch (IllegalArgumentException e1) {
            throw new IOException("Fatal error during MAC startup!");
        }
        this.tm.changeSendCipher(cbc, mac);
        this.tm.kexFinished();
    }

    private boolean verifySignature(byte[] sig, byte[] hostkey) throws IOException {
        if (this.kxs.np.server_host_key_algo.equals("ssh-rsa")) {
            return RSASha1Verify.verifySignature(this.kxs.H, sig, hostkey);
        }
        if (this.kxs.np.server_host_key_algo.equals("ssh-dss")) {
            DSASignature ds = DsaSha1Verify.decodeDSASignature(sig);
            DSAPublicKey dpk = DsaSha1Verify.decodeDSAPublicKey(hostkey);
            return DsaSha1Verify.verifySignature(this.kxs.H, ds, dpk);
        }
        throw new IOException("Unknown server host key algorithm '" + this.kxs.np.server_host_key_algo + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleMessage(byte[] msg, int msglen) throws IOException {
        if (msg == null) {
            Object object = this.accessLock;
            synchronized (object) {
                this.connectionClosed = true;
                this.accessLock.notifyAll();
                return;
            }
        }
        if (this.kxs == null && msg[0] != 20) {
            throw new IOException("Unexpected KEX message (type " + msg[0] + ")");
        }
        if (this.ignore_next_kex_packet) {
            this.ignore_next_kex_packet = false;
            return;
        }
        if (msg[0] == 20) {
            PacketKexInit kip;
            if (this.kxs != null && this.kxs.state != 0) {
                throw new IOException("Unexpected SSH_MSG_KEXINIT message during on-going kex exchange!");
            }
            if (this.kxs == null) {
                this.kxs = new KexState();
                this.kxs.dhgexParameters = this.nextKEXdhgexParameters;
                this.kxs.localKEX = kip = new PacketKexInit(this.nextKEXcryptoWishList);
                this.tm.sendKexMessage(kip.getPayload());
            }
            this.kxs.remoteKEX = kip = new PacketKexInit(msg, 0, msglen);
            this.kxs.np = this.mergeKexParameters(this.kxs.localKEX.getKexParameters(), this.kxs.remoteKEX.getKexParameters());
            if (this.kxs.np == null) {
                throw new IOException("Cannot negotiate, proposals do not match.");
            }
            if (this.kxs.remoteKEX.isFirst_kex_packet_follows() && !this.kxs.np.guessOK) {
                this.ignore_next_kex_packet = true;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group-exchange-sha1")) {
                PacketKexDhGexRequest dhgexreq = new PacketKexDhGexRequest(this.kxs.dhgexParameters);
                this.tm.sendKexMessage(dhgexreq.getPayload());
                this.kxs.state = 1;
                return;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1")) {
                this.kxs.dhx = new DhExchange();
                this.kxs.dhx.init();
                PacketKexDHInit kp = new PacketKexDHInit(this.kxs.dhx.getE());
                this.tm.sendKexMessage(kp.getPayload());
                this.kxs.state = 1;
                return;
            }
            throw new IllegalStateException("Unkown KEX method!");
        }
        if (msg[0] == 21) {
            MAC mac;
            BlockCipher cbc;
            if (this.km == null) {
                throw new IOException("Peer sent SSH_MSG_NEWKEYS, but I have no key material ready!");
            }
            try {
                cbc = BlockCipherFactory.createCipher(this.kxs.np.enc_algo_server_to_client, false, this.km.enc_key_server_to_client, this.km.initial_iv_server_to_client);
                mac = new MAC(this.kxs.np.mac_algo_server_to_client, this.km.integrity_key_server_to_client);
            }
            catch (IllegalArgumentException e1) {
                throw new IOException("Fatal error during MAC startup!");
            }
            this.tm.changeRecvCipher(cbc, mac);
            ConnectionInfo sci = new ConnectionInfo();
            ++this.kexCount;
            sci.clientToServerCryptoAlgorithm = this.kxs.np.enc_algo_client_to_server;
            sci.serverToClientCryptoAlgorithm = this.kxs.np.enc_algo_server_to_client;
            sci.clientToServerMACAlgorithm = this.kxs.np.mac_algo_client_to_server;
            sci.serverToClientMACAlgorithm = this.kxs.np.mac_algo_server_to_client;
            sci.serverHostKeyAlgorithm = this.kxs.np.server_host_key_algo;
            sci.serverHostKey = this.kxs.hostkey;
            sci.keyExchangeCounter = this.kexCount;
            Object object = this.accessLock;
            synchronized (object) {
                this.lastConnInfo = sci;
                this.accessLock.notifyAll();
            }
            this.kxs = null;
            return;
        }
        if (this.kxs == null || this.kxs.state == 0) {
            throw new IOException("Unexpected Kex submessage!");
        }
        if (this.kxs.np.kex_algo.equals("diffie-hellman-group-exchange-sha1")) {
            if (this.kxs.state == 1) {
                PacketKexDhGexGroup dhgexgrp = new PacketKexDhGexGroup(msg, 0, msglen);
                this.kxs.dhgx = new DhGroupExchange(dhgexgrp.getP(), dhgexgrp.getG());
                this.kxs.dhgx.init();
                PacketKexDhGexInit dhgexinit = new PacketKexDhGexInit(this.kxs.dhgx.getE());
                this.tm.sendKexMessage(dhgexinit.getPayload());
                this.kxs.state = 2;
                return;
            }
            if (this.kxs.state == 2) {
                PacketKexDhGexReply dhgexrpl = new PacketKexDhGexReply(msg, 0, msglen);
                this.kxs.dhgx.setF(dhgexrpl.getF());
                this.kxs.hostkey = dhgexrpl.getHostKey();
                try {
                    this.kxs.H = this.kxs.dhgx.calculateH(this.csh.getClientString(), this.csh.getServerString(), this.kxs.localKEX.getPayload(), this.kxs.remoteKEX.getPayload(), dhgexrpl.getHostKey(), this.kxs.dhgexParameters);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Problem during KEX: " + e.getMessage());
                }
                boolean res = this.verifySignature(dhgexrpl.getSignature(), this.kxs.hostkey);
                if (!res) {
                    throw new IOException("Signature sent by remote is wrong!");
                }
                if (this.verifier != null && !this.verifier.verifyServerHostKey(this.hostname, this.port, this.kxs.np.server_host_key_algo, this.kxs.hostkey)) {
                    throw new IOException("Host key was not accepted by verifier callback.");
                }
                this.kxs.K = this.kxs.dhgx.getK();
                this.finishKex();
                return;
            }
            throw new IllegalStateException("Illegal State in KEX Exchange!");
        }
        if (this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1") && this.kxs.state == 1) {
            PacketKexDHReply dhr = new PacketKexDHReply(msg, 0, msglen);
            this.kxs.hostkey = dhr.getHostKey();
            this.kxs.dhx.setF(dhr.getF());
            try {
                this.kxs.H = this.kxs.dhx.calculateH(this.csh.getClientString(), this.csh.getServerString(), this.kxs.localKEX.getPayload(), this.kxs.remoteKEX.getPayload(), dhr.getHostKey());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Problems during KEX: " + e.getMessage());
            }
            boolean res = this.verifySignature(dhr.getSignature(), this.kxs.hostkey);
            if (!res) {
                throw new IOException("FATAL: Signature is wrong!");
            }
            if (this.verifier != null && !this.verifier.verifyServerHostKey(this.hostname, this.port, this.kxs.np.server_host_key_algo, this.kxs.hostkey)) {
                throw new IOException("Host key was not accepted by verifier callback.");
            }
            this.kxs.K = this.kxs.dhx.getK();
            this.finishKex();
            return;
        }
        throw new IllegalStateException("Unkown KEX method! (" + this.kxs.np.kex_algo + ")");
    }
}

