/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Session {
    ChannelManager cm;
    Channel cn;
    boolean flag_pty_requested = false;
    boolean flag_execution_started = false;
    boolean flag_closed = false;

    Session(ChannelManager cm) throws IOException {
        this.cm = cm;
        this.cn = cm.createSessionChannel();
    }

    public synchronized void requestDumbPTY() throws IOException {
        this.requestPTY("dumb", 0, 0, 0, 0, null);
    }

    public synchronized void requestPTY(String term) throws IOException {
        this.requestPTY(term, 0, 0, 0, 0, null);
    }

    public synchronized void requestPTY(String term, int term_width_characters, int term_height_characters, int term_width_pixels, int term_height_pixels, byte[] terminal_modes) throws IOException {
        if (this.flag_closed) {
            throw new IOException("This session is closed.");
        }
        if (this.flag_pty_requested) {
            throw new IOException("A PTY was already requested.");
        }
        if (this.flag_execution_started) {
            throw new IOException("Cannot request PTY at this stage anymore, a remote execution has already started.");
        }
        if (term == null) {
            throw new IllegalArgumentException("TERM cannot be null.");
        }
        if (terminal_modes != null && terminal_modes.length > 0) {
            if (terminal_modes[terminal_modes.length - 1] != 0) {
                throw new IOException("Illegal terminal modes description, does not end in zero byte");
            }
        } else {
            terminal_modes = new byte[1];
        }
        this.flag_pty_requested = true;
        this.cm.requestPTY(this.cn, term, term_width_characters, term_height_characters, term_width_pixels, term_height_pixels, terminal_modes);
    }

    public synchronized void execCommand(String cmd) throws IOException {
        if (this.flag_closed) {
            throw new IOException("This session is closed.");
        }
        if (this.flag_execution_started) {
            throw new IOException("A remote execution has already started.");
        }
        this.flag_execution_started = true;
        this.cm.execCommand(this.cn, cmd);
    }

    public synchronized void startShell() throws IOException {
        if (this.flag_closed) {
            throw new IOException("This session is closed.");
        }
        if (this.flag_execution_started) {
            throw new IOException("A remote execution has already started.");
        }
        this.flag_execution_started = true;
        this.cm.startShell(this.cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InputStream getStdout() throws IOException {
        Channel channel = this.cn;
        synchronized (channel) {
            if (this.cn.stdoutStream == null) {
                throw new IOException("STDOUT is not available");
            }
            return this.cn.stdoutStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InputStream getStderr() throws IOException {
        Channel channel = this.cn;
        synchronized (channel) {
            if (this.cn.stderrStream == null) {
                throw new IOException("STDERR is not available");
            }
            return this.cn.stderrStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OutputStream getStdin() throws IOException {
        Channel channel = this.cn;
        synchronized (channel) {
            if (this.cn.stdinStream == null) {
                throw new IOException("STDIN is not available");
            }
            return this.cn.stdinStream;
        }
    }

    public synchronized int waitUntilDataAvailable(long timeout) throws IOException {
        if (this.cn.stdoutStream.available() > 0) {
            return 1;
        }
        if (this.cn.stderrStream.available() > 0) {
            return 1;
        }
        return this.cm.waitUntilDataAvailable(this.cn, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Integer getExitStatus() {
        Channel channel = this.cn;
        synchronized (channel) {
            return this.cn.exit_status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getExitSignal() {
        Channel channel = this.cn;
        synchronized (channel) {
            return this.cn.exit_signal;
        }
    }

    public synchronized void close() {
        if (!this.flag_closed) {
            try {
                this.cm.closeChannel(this.cn, "Closed due to user request");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.flag_closed = true;
        }
    }
}

