/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel;

import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.util.PoiMergeCellUtil;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelBuilder {
    private Workbook workbook;
    private Sheet sheet;
    private CellStyle centerStyle;
    private Short rowHeight = 300;

    private ExcelBuilder() {
    }

    public static ExcelBuilder create() {
        return ExcelBuilder.create(ExcelType.XSSF);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public ExcelBuilder setRowHeight(int rowHeight) {
        this.rowHeight = (short)(rowHeight * 20);
        return this;
    }

    public static ExcelBuilder create(ExcelType type) {
        ExcelBuilder eb = new ExcelBuilder();
        if (ExcelType.HSSF.equals((Object)type)) {
            eb.workbook = new HSSFWorkbook();
            eb.sheet = eb.workbook.createSheet();
        } else {
            eb.workbook = new XSSFWorkbook();
            eb.sheet = eb.workbook.createSheet();
        }
        eb.centerStyle = eb.workbook.createCellStyle();
        eb.centerStyle.setAlignment(HorizontalAlignment.CENTER);
        eb.centerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return eb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String path) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            this.workbook.write((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)fos);
        }
        IOUtils.closeQuietly((Closeable)fos);
    }

    public ExcelBuilder addNoneRow() {
        Row row = this.getNewRow();
        row.setHeight(this.rowHeight.shortValue());
        return this;
    }

    private Row getNewRow() {
        return this.workbook.getSheetAt(0).createRow(this.sheet.getRow(0) == null ? 0 : this.sheet.getLastRowNum() + 1);
    }

    public ExcelBuilder addOneRow(String content) {
        Row row = this.getNewRow();
        row.setHeight(this.rowHeight.shortValue());
        row.createCell(0).setCellValue(content);
        row.getCell(0).setCellStyle(this.centerStyle);
        return this;
    }

    public ExcelBuilder addOneRow(String content, int cellSize) {
        Row row = this.getNewRow();
        row.setHeight(this.rowHeight.shortValue());
        row.createCell(0).setCellValue(content);
        row.getCell(0).setCellStyle(this.centerStyle);
        PoiMergeCellUtil.addMergedRegion(this.sheet, row.getRowNum(), row.getRowNum(), 0, cellSize - 1);
        return this;
    }

    public ExcelBuilder addOneRow(String content, int cellSize, int rowHeight, CellStyle style) {
        Row row = this.getNewRow();
        row.setHeight((short)(rowHeight * 20));
        row.createCell(0).setCellValue(content);
        row.getCell(0).setCellStyle(style);
        PoiMergeCellUtil.addMergedRegion(this.sheet, row.getRowNum(), row.getRowNum(), 0, cellSize - 1);
        return this;
    }

    public ExcelBuilder addOneRow(List<String> content) {
        Row row = this.getNewRow();
        return this;
    }

    public ExcelBuilder addOneCell(String content, int rowIndex, int cellIndex) {
        Cell cell = this.sheet.getRow(rowIndex).getCell(cellIndex) == null ? this.sheet.getRow(rowIndex).createCell(cellIndex) : this.sheet.getRow(rowIndex).getCell(cellIndex);
        cell.setCellValue(content);
        cell.setCellStyle(this.centerStyle);
        return this;
    }

    public ExcelBuilder addOneCell(String content, int rowIndex, int cellIndex, int lastRow, int lastCell) {
        Cell cell = this.sheet.getRow(rowIndex).getCell(cellIndex) == null ? this.sheet.getRow(rowIndex).createCell(cellIndex) : this.sheet.getRow(rowIndex).getCell(cellIndex);
        cell.setCellValue(content);
        cell.setCellStyle(this.centerStyle);
        PoiMergeCellUtil.addMergedRegion(this.sheet, rowIndex, lastRow, cellIndex, lastCell);
        return this;
    }

    public ExcelBuilder addOneCell(String content, int rowIndex, int cellIndex, int lastRow, int lastCell, BorderStyle borderStyle) {
        Cell cell = this.sheet.getRow(rowIndex).getCell(cellIndex) == null ? this.sheet.getRow(rowIndex).createCell(cellIndex) : this.sheet.getRow(rowIndex).getCell(cellIndex);
        cell.setCellValue(content);
        cell.setCellStyle(this.centerStyle);
        PoiMergeCellUtil.addMergedRegion(this.sheet, rowIndex, lastRow, cellIndex, lastCell);
        PoiMergeCellUtil.setBorder(borderStyle, this.sheet, rowIndex, lastRow, cellIndex, lastCell);
        return this;
    }

    public ExcelBuilder addCells(String[] contentArr, int rowIndex, int cellIndex) {
        for (int i = 0; i < contentArr.length; ++i) {
            this.addOneCell(contentArr[i], rowIndex, cellIndex + i);
        }
        return this;
    }

    public ExcelBuilder addCells(List<String> contentList, int rowIndex, int cellIndex) {
        for (int i = 0; i < contentList.size(); ++i) {
            this.addOneCell(contentList.get(i), rowIndex, cellIndex + i);
        }
        return this;
    }

    public ExcelBuilder addRows(List dataList, String[] names, int rowIndex, int cellIndex) {
        for (int i = 0; i < dataList.size(); ++i) {
            Row row = this.getRow(rowIndex + i);
            Object obj = dataList.get(i);
            if (!(obj instanceof Map)) continue;
            Map map = (Map)obj;
            for (int j = 0; j < names.length; ++j) {
                this.addOneCell((String)map.get(names[j]), rowIndex + i, cellIndex + j);
            }
        }
        return this;
    }

    public ExcelBuilder addRows(List dataList, String[] names, int rowIndex, int cellIndex, BorderStyle borderStyle) {
        this.addRows(dataList, names, rowIndex, cellIndex);
        PoiMergeCellUtil.setBorder(borderStyle, this.sheet, rowIndex, rowIndex + dataList.size() - 1, cellIndex, cellIndex + names.length - 1);
        return this;
    }

    private Row getRow(int index) {
        if (this.sheet.getRow(index) == null) {
            return this.sheet.createRow(index);
        }
        return this.sheet.getRow(index);
    }
}

