/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.pdf.watermark;

import cn.afterturn.easypoi.pdf.watermark.IWatermarkProcessor;
import cn.afterturn.easypoi.pdf.watermark.RemoveResult;
import cn.afterturn.easypoi.pdf.watermark.WatermarkRemover;
import cn.afterturn.easypoi.pdf.watermark.WatermarkScanner;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class WatermarkProcessor
implements IWatermarkProcessor {
    public PDDocument document = null;
    private Set<String> watermarkWordSet = new HashSet<String>();

    @Override
    public void init(PDDocument document) {
        this.document = document;
        int threadCount = this.getThreadCount();
        CompletableFuture[] scancerTasks = new CompletableFuture[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            int pageStart = i * 3;
            scancerTasks[i] = CompletableFuture.runAsync(() -> {
                WatermarkScanner scanner = new WatermarkScanner(this, pageStart, 3);
                scanner.run();
            });
        }
        CompletableFuture.allOf(scancerTasks).join();
    }

    public void removeWatermark(PDDocument document) throws Exception {
        int threadCount = this.getThreadCount();
        CompletableFuture[] removerTasks = new CompletableFuture[threadCount];
        Vector removeResults = new Vector();
        for (int i = 0; i < threadCount; ++i) {
            int pageStart = i * 3;
            removerTasks[i] = CompletableFuture.runAsync(() -> {
                WatermarkRemover remover = new WatermarkRemover(this, pageStart, 3, null);
                remover.removeWatermark();
                removeResults.addAll(remover.getPageTokens());
            });
        }
        CompletableFuture.allOf(removerTasks).join();
        Collections.sort(removeResults, new Comparator<RemoveResult>(){

            @Override
            public int compare(RemoveResult o1, RemoveResult o2) {
                return o1.getPageNo() - o2.getPageNo();
            }
        });
        for (RemoveResult result : removeResults) {
            PDStream updatedStream = new PDStream(document);
            OutputStream out = updatedStream.createOutputStream(COSName.FLATE_DECODE);
            ContentStreamWriter tokenWriter = new ContentStreamWriter(out);
            tokenWriter.writeTokens(result.getTokens());
            out.close();
            result.getPage().setContents(updatedStream);
        }
    }

    public void removeWatermark(List<String> watermarks) throws Exception {
        int threadCount = this.getThreadCount();
        CompletableFuture[] removerTasks = new CompletableFuture[threadCount];
        Vector removeResults = new Vector();
        for (int i = 0; i < threadCount; ++i) {
            int pageStart = i * 3;
            removerTasks[i] = CompletableFuture.runAsync(() -> {
                WatermarkRemover remover = new WatermarkRemover(this, pageStart, 3, watermarks);
                remover.removeWatermark();
                removeResults.addAll(remover.getPageTokens());
            });
        }
        CompletableFuture.allOf(removerTasks).join();
        Collections.sort(removeResults, new Comparator<RemoveResult>(){

            @Override
            public int compare(RemoveResult o1, RemoveResult o2) {
                return o1.getPageNo() - o2.getPageNo();
            }
        });
        for (RemoveResult result : removeResults) {
            PDStream updatedStream = new PDStream(this.document);
            OutputStream out = updatedStream.createOutputStream(COSName.FLATE_DECODE);
            ContentStreamWriter tokenWriter = new ContentStreamWriter(out);
            tokenWriter.writeTokens(result.getTokens());
            out.close();
            result.getPage().setContents(updatedStream);
        }
    }

    @Override
    public PDDocument getDocument() {
        return this.document;
    }

    @Override
    public boolean isWatermarkWord(String str) {
        return this.watermarkWordSet.contains(str);
    }

    @Override
    public void addWatermarkWord(String str) {
        this.watermarkWordSet.add(str);
    }
}

