/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.pdf.watermark;

import cn.afterturn.easypoi.pdf.watermark.IWatermarkProcessor;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.DrawObject;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkScanner
extends PDFStreamEngine {
    Logger logger = LoggerFactory.getLogger(WatermarkScanner.class);
    IWatermarkProcessor remover;
    int pageStartIndex;
    int pageLength;

    public WatermarkScanner(IWatermarkProcessor remover, int pageStartIndex, int pageLength) {
        this.addOperator((OperatorProcessor)new Concatenate());
        this.addOperator((OperatorProcessor)new DrawObject());
        this.addOperator((OperatorProcessor)new SetGraphicsStateParameters());
        this.addOperator((OperatorProcessor)new Save());
        this.addOperator((OperatorProcessor)new Restore());
        this.addOperator((OperatorProcessor)new SetMatrix());
        this.remover = remover;
        this.pageStartIndex = pageStartIndex;
        this.pageLength = pageLength;
    }

    public void run() {
        try {
            for (int i = this.pageStartIndex; i < this.pageStartIndex + this.pageLength && i < this.remover.getDocument().getNumberOfPages(); ++i) {
                this.processPage(this.remover.getDocument().getPage(i));
            }
        }
        catch (Exception e) {
            this.logger.error("\u3010\u626b\u63cf\u9875\u9762\u6c34\u5370\u51fa\u9519\u3011", (Throwable)e);
        }
    }

    protected void processOperator(Operator operator, List<COSBase> operands) throws IOException {
        String operation = operator.getName();
        if ("Tj".equals(operation)) {
            COSString textObj = (COSString)operands.get(0);
            String string = textObj.getString();
            Matrix matrix = this.getTextLineMatrix();
            if (matrix != null && matrix.getScaleY() != 0.0f && matrix.getScaleY() != 1.0f && matrix.getShearY() != 0.0f && !this.remover.isWatermarkWord(string)) {
                this.remover.addWatermarkWord(string);
            }
        } else {
            super.processOperator(operator, operands);
        }
    }
}

