/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.word.parse.excel;

import cn.afterturn.easypoi.entity.ImageEntity;
import cn.afterturn.easypoi.excel.entity.params.ExcelForEachParams;
import cn.afterturn.easypoi.util.PoiElUtil;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.word.entity.MyXWPFDocument;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelMapParse {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelMapParse.class);

    public static void addAnImage(ImageEntity obj, XWPFRun currentRun) {
        try {
            Object[] isAndType = PoiPublicUtil.getIsAndType(obj);
            String picId = currentRun.getDocument().addPictureData((byte[])isAndType[0], ((Integer)isAndType[1]).intValue());
            if (obj.getLocationType() == ImageEntity.EMBED) {
                ((MyXWPFDocument)currentRun.getDocument()).createPicture(currentRun, picId, currentRun.getDocument().getNextPicNameNumber(((Integer)isAndType[1]).intValue()), obj.getWidth(), obj.getHeight());
            } else if (obj.getLocationType() == ImageEntity.ABOVE) {
                ((MyXWPFDocument)currentRun.getDocument()).createPicture(currentRun, picId, currentRun.getDocument().getNextPicNameNumber(((Integer)isAndType[1]).intValue()), obj.getWidth(), obj.getHeight(), false);
            } else if (obj.getLocationType() == ImageEntity.BEHIND) {
                ((MyXWPFDocument)currentRun.getDocument()).createPicture(currentRun, picId, currentRun.getDocument().getNextPicNameNumber(((Integer)isAndType[1]).intValue()), obj.getWidth(), obj.getHeight(), true);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void addAnImage(ImageEntity obj, XWPFTableCell cell) {
        List paragraphs = cell.getParagraphs();
        XWPFParagraph newPara = (XWPFParagraph)paragraphs.get(0);
        XWPFRun imageCellRun = newPara.createRun();
        ExcelMapParse.addAnImage(obj, imageCellRun);
    }

    private static String[] parseCurrentRowGetParams(XWPFTableRow currentRow) {
        List cells = currentRow.getTableCells();
        String[] params = new String[cells.size()];
        for (int i = 0; i < cells.size(); ++i) {
            String text = ((XWPFTableCell)cells.get(i)).getText();
            params[i] = text == null ? "" : text.trim().replace("{{", "").replace("}}", "");
        }
        return params;
    }

    private static List<ExcelForEachParams> parseCurrentRowGetParamsEntity(XWPFTableRow currentRow) {
        List cells = currentRow.getTableCells();
        ArrayList<ExcelForEachParams> params = new ArrayList<ExcelForEachParams>();
        for (int i = 0; i < cells.size(); ++i) {
            ExcelForEachParams param = new ExcelForEachParams();
            String text = ((XWPFTableCell)cells.get(i)).getText();
            param.setName(text == null ? "" : text.trim().replace("{{", "").replace("}}", ""));
            if (((XWPFTableCell)cells.get(i)).getCTTc().getTcPr().getGridSpan() != null && ((XWPFTableCell)cells.get(i)).getCTTc().getTcPr().getGridSpan().getVal() != null) {
                param.setColspan(((XWPFTableCell)cells.get(i)).getCTTc().getTcPr().getGridSpan().getVal().intValue());
            }
            param.setHeight((short)currentRow.getHeight());
            params.add(param);
        }
        return params;
    }

    public static void parseNextRowAndAddRow(XWPFTable table, int index, List<Object> list) throws Exception {
        XWPFTableRow currentRow = table.getRow(index);
        List<ExcelForEachParams> paramsList = ExcelMapParse.parseCurrentRowGetParamsEntity(currentRow);
        String listname = paramsList.get(0).getName();
        boolean isCreate = !listname.contains("!fe:");
        listname = listname.replace("!fe:", "").replace("$fe:", "").replace("fe:", "").replace("{{", "");
        String[] keys = listname.replaceAll("\\s{1,}", " ").trim().split(" ");
        paramsList.get(0).setName(keys[1]);
        ArrayList tempCellList = new ArrayList();
        tempCellList.addAll(table.getRow(index).getTableCells());
        int cellIndex = 0;
        HashMap tempMap = Maps.newHashMap();
        LOGGER.debug("start for each data list :{}", (Object)list.size());
        for (Object obj : list) {
            Object val;
            currentRow = isCreate ? table.insertNewTableRow(index++) : table.getRow(index++);
            tempMap.put("t", obj);
            for (cellIndex = 0; cellIndex < currentRow.getTableCells().size(); ++cellIndex) {
                val = PoiElUtil.eval(paramsList.get(cellIndex).getName(), tempMap);
                ExcelMapParse.clearParagraphText(((XWPFTableCell)currentRow.getTableCells().get(cellIndex)).getParagraphs());
                if (val instanceof ImageEntity) {
                    ExcelMapParse.addAnImage((ImageEntity)val, (XWPFTableCell)tempCellList.get(cellIndex));
                    continue;
                }
                PoiPublicUtil.copyCellAndSetValue((XWPFTableCell)tempCellList.get(cellIndex), (XWPFTableCell)currentRow.getTableCells().get(cellIndex), val.toString());
            }
            while (cellIndex < paramsList.size()) {
                val = PoiElUtil.eval(paramsList.get(cellIndex).getName(), tempMap);
                XWPFTableCell cell = currentRow.createCell();
                if (paramsList.get(cellIndex).getColspan() > 1) {
                    cell.getCTTc().addNewTcPr().addNewGridSpan().setVal(new BigInteger(paramsList.get(cellIndex).getColspan() + ""));
                }
                if (val instanceof ImageEntity) {
                    ExcelMapParse.addAnImage((ImageEntity)val, cell);
                } else {
                    PoiPublicUtil.copyCellAndSetValue((XWPFTableCell)tempCellList.get(cellIndex), cell, val.toString());
                }
                ++cellIndex;
            }
        }
        table.removeRow(index);
    }

    private static void clearParagraphText(List<XWPFParagraph> paragraphs) {
        paragraphs.forEach(pp -> {
            if (pp.getRuns() != null) {
                for (int i = pp.getRuns().size() - 1; i >= 0; --i) {
                    pp.removeRun(i);
                }
            }
        });
    }
}

