/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.mgmt;

import cn.authing.core.graphql.GraphQLCall;
import cn.authing.core.graphql.GraphQLResponse;
import cn.authing.core.http.HttpCall;
import cn.authing.core.mgmt.ManagementClient;
import cn.authing.core.mgmt.OrgManagementClient;
import cn.authing.core.types.AddNodeV2Param;
import cn.authing.core.types.ChildrenNodesParam;
import cn.authing.core.types.ChildrenNodesResponse;
import cn.authing.core.types.CommonMessage;
import cn.authing.core.types.CreateOrgParam;
import cn.authing.core.types.DeleteNodeParam;
import cn.authing.core.types.DeleteNodeResponse;
import cn.authing.core.types.DeleteOrgParam;
import cn.authing.core.types.DeleteOrgResponse;
import cn.authing.core.types.IsRootNodeParam;
import cn.authing.core.types.IsRootNodeResponse;
import cn.authing.core.types.ListNodeByCodeAuthorizedResourcesResponse;
import cn.authing.core.types.ListNodeByIdAuthorizedResourcesParam;
import cn.authing.core.types.MoveNodeParam;
import cn.authing.core.types.MoveNodeResponse;
import cn.authing.core.types.Node;
import cn.authing.core.types.NodeByIdParam;
import cn.authing.core.types.NodeByIdResponse;
import cn.authing.core.types.NodeByIdWithMembersParam;
import cn.authing.core.types.NodeByIdWithMembersResponse;
import cn.authing.core.types.Org;
import cn.authing.core.types.OrgNode;
import cn.authing.core.types.OrgParam;
import cn.authing.core.types.OrgResponse;
import cn.authing.core.types.OrgsParam;
import cn.authing.core.types.PaginatedOrgs;
import cn.authing.core.types.RemoveMemberParam;
import cn.authing.core.types.RemoveMemberResponse;
import cn.authing.core.types.RestAddMembersParams;
import cn.authing.core.types.RestfulResponse;
import cn.authing.core.types.RootNodeParam;
import cn.authing.core.types.RootNodeResponse;
import cn.authing.core.types.SearchNodesParam;
import cn.authing.core.types.UpdateNodeParam;
import cn.authing.core.types.UpdateNodeResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ \u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0007\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010\u000e\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\nJ\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u000e\u001a\u00020\u001aJ$\u0010\u001b\u001a \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\f0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\f0\u0006J \u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u0007\u0012\u0004\u0012\u00020\u001c0\u00062\u0006\u0010\u001e\u001a\u00020\nJ\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00110\u00142\u0006\u0010\u0017\u001a\u00020\nJ\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\t\u001a\u00020\nJ \u0010#\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u0007\u0012\u0004\u0012\u00020\u001c0\u00062\u0006\u0010$\u001a\u00020\nJ\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nJ \u0010(\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u0007\u0012\u0004\u0012\u00020)0\u00062\u0006\u0010\u000e\u001a\u00020*J\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u000e\u001a\u00020-J(\u0010.\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u00142\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u001a\u00100\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u000e\u001a\u000202J*\u00103\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u00110\u00142\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u00105\u001a\u00020\nJ(\u00106\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u001a\u00108\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u000e\u001a\u00020:J,\u0010;\u001a \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u00062\u0006\u0010\u000e\u001a\u00020<J\u001a\u0010=\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u000e\u001a\u00020?R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcn/authing/core/mgmt/OrgManagementClient;", "", "client", "Lcn/authing/core/mgmt/ManagementClient;", "(Lcn/authing/core/mgmt/ManagementClient;)V", "addMembers", "Lcn/authing/core/http/HttpCall;", "Lcn/authing/core/types/RestfulResponse;", "Lcn/authing/core/types/Node;", "nodeId", "", "userIds", "", "addNode", "param", "Lcn/authing/core/types/AddNodeV2Param;", "create", "Lcn/authing/core/types/Org;", "Lcn/authing/core/types/CreateOrgParam;", "deleteById", "Lcn/authing/core/graphql/GraphQLCall;", "Lcn/authing/core/types/DeleteOrgResponse;", "Lcn/authing/core/types/CommonMessage;", "id", "deleteNode", "Lcn/authing/core/types/DeleteNodeResponse;", "Lcn/authing/core/types/DeleteNodeParam;", "exportAll", "Lcn/authing/core/types/OrgNode;", "exportByOrgId", "orgId", "findById", "Lcn/authing/core/types/OrgResponse;", "findNodeById", "Lcn/authing/core/types/NodeByIdResponse;", "importByJson", "json", "isRootNode", "Lcn/authing/core/types/IsRootNodeResponse;", "", "list", "Lcn/authing/core/types/PaginatedOrgs;", "Lcn/authing/core/types/OrgsParam;", "listAuthorizedResourcesByNodeId", "Lcn/authing/core/types/ListNodeByCodeAuthorizedResourcesResponse;", "Lcn/authing/core/types/ListNodeByIdAuthorizedResourcesParam;", "listChildren", "Lcn/authing/core/types/ChildrenNodesResponse;", "listMembers", "Lcn/authing/core/types/NodeByIdWithMembersResponse;", "Lcn/authing/core/types/NodeByIdWithMembersParam;", "moveNode", "Lcn/authing/core/types/MoveNodeResponse;", "targetParentId", "removeMembers", "Lcn/authing/core/types/RemoveMemberResponse;", "rootNode", "Lcn/authing/core/types/RootNodeResponse;", "Lcn/authing/core/types/RootNodeParam;", "searchNodes", "Lcn/authing/core/types/SearchNodesParam;", "updateNode", "Lcn/authing/core/types/UpdateNodeResponse;", "Lcn/authing/core/types/UpdateNodeParam;", "core"})
public final class OrgManagementClient {
    private final ManagementClient client;

    @NotNull
    public final HttpCall<RestfulResponse<Org>, Org> create(@NotNull CreateOrgParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        String string = this.client.getHost() + "/api/v2/orgs";
        String string2 = new GsonBuilder().create().toJson((Object)param);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GsonBuilder().create().toJson(param)");
        return this.client.createHttpPostCall$core(string, string2, (TypeToken)new TypeToken<RestfulResponse<Org>>(){}, create.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<DeleteOrgResponse, CommonMessage> deleteById(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        DeleteOrgParam param = new DeleteOrgParam(id);
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<DeleteOrgResponse>>(){}, deleteById.2.INSTANCE);
    }

    @NotNull
    public final HttpCall<RestfulResponse<PaginatedOrgs>, PaginatedOrgs> list(@NotNull OrgsParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        String url = this.client.getHost() + "/api/v2/orgs/pagination";
        Integer n = param.getLimit();
        url = url + "?limit=" + (n != null ? n : -1);
        url = url + (param.getPage() != null ? "&page=" + param.getPage() : "");
        url = url + (param.getSortBy() != null ? "&sortBy=" + (Object)((Object)param.getSortBy()) : "");
        return this.client.createHttpGetCall$core(url, (TypeToken)new TypeToken<RestfulResponse<PaginatedOrgs>>(){}, list.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<NodeByIdResponse, Node> findNodeById(@NotNull String nodeId) {
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        NodeByIdParam param = new NodeByIdParam(nodeId);
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<NodeByIdResponse>>(){}, findNodeById.2.INSTANCE);
    }

    @NotNull
    public final HttpCall<RestfulResponse<Node>, Node> addNode(@NotNull AddNodeV2Param param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        String string = this.client.getHost() + "/api/v2/orgs/" + param.getOrgId() + "/nodes";
        String string2 = new GsonBuilder().create().toJson((Object)param);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GsonBuilder().create().toJson(param)");
        return this.client.createHttpPostCall$core(string, string2, (TypeToken)new TypeToken<RestfulResponse<Node>>(){}, addNode.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<UpdateNodeResponse, Node> updateNode(@NotNull UpdateNodeParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<UpdateNodeResponse>>(){}, updateNode.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<DeleteNodeResponse, CommonMessage> deleteNode(@NotNull DeleteNodeParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<DeleteNodeResponse>>(){}, deleteNode.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<MoveNodeResponse, Org> moveNode(@NotNull String orgId, @NotNull String nodeId, @NotNull String targetParentId) {
        Intrinsics.checkParameterIsNotNull((Object)orgId, (String)"orgId");
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        Intrinsics.checkParameterIsNotNull((Object)targetParentId, (String)"targetParentId");
        MoveNodeParam param = new MoveNodeParam(orgId, nodeId, targetParentId);
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<MoveNodeResponse>>(){}, moveNode.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<IsRootNodeResponse, Boolean> isRootNode(@NotNull String nodeId, @NotNull String orgId) {
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        Intrinsics.checkParameterIsNotNull((Object)orgId, (String)"orgId");
        IsRootNodeParam param = new IsRootNodeParam(nodeId, orgId);
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<IsRootNodeResponse>>(){}, isRootNode.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<RootNodeResponse, Node> rootNode(@NotNull RootNodeParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<RootNodeResponse>>(){}, rootNode.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<ChildrenNodesResponse, List<Node>> listChildren(@NotNull String orgId, @NotNull String nodeId) {
        Intrinsics.checkParameterIsNotNull((Object)orgId, (String)"orgId");
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        ChildrenNodesParam param = new ChildrenNodesParam(orgId, nodeId);
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<ChildrenNodesResponse>>(){}, listChildren.2.INSTANCE);
    }

    @NotNull
    public final HttpCall<RestfulResponse<List<Node>>, List<Node>> searchNodes(@NotNull SearchNodesParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.client.createHttpGetCall$core(this.client.getHost() + "/api/v2/orgs/nodes/search?q=" + param.getKeyword(), (TypeToken)new TypeToken<RestfulResponse<List<? extends Node>>>(){}, searchNodes.2.INSTANCE);
    }

    @NotNull
    public final HttpCall<RestfulResponse<Node>, Node> addMembers(@NotNull String nodeId, @NotNull List<String> userIds) {
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        Intrinsics.checkParameterIsNotNull(userIds, (String)"userIds");
        RestAddMembersParams options = new RestAddMembersParams(nodeId, userIds);
        String string = this.client.getHost() + "/api/v2/orgs/nodes/" + options.getNodeId() + "/members";
        String string2 = new GsonBuilder().create().toJson((Object)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GsonBuilder().create().toJson(options)");
        return this.client.createHttpPostCall$core(string, string2, (TypeToken)new TypeToken<RestfulResponse<Node>>(){}, addMembers.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<NodeByIdWithMembersResponse, Node> listMembers(@NotNull NodeByIdWithMembersParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<NodeByIdWithMembersResponse>>(){}, listMembers.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<RemoveMemberResponse, Node> removeMembers(@NotNull String nodeId, @NotNull List<String> userIds) {
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        Intrinsics.checkParameterIsNotNull(userIds, (String)"userIds");
        RemoveMemberParam param = new RemoveMemberParam(null, null, null, null, nodeId, null, null, userIds, 111, null);
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<RemoveMemberResponse>>(){}, removeMembers.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<OrgResponse, Org> findById(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        OrgParam param = new OrgParam(id);
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<OrgResponse>>(){}, findById.2.INSTANCE);
    }

    @NotNull
    public final HttpCall<RestfulResponse<OrgNode>, OrgNode> importByJson(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Gson gson = new Gson();
        Map node = (Map)gson.fromJson(json, Map.class);
        Map data = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"filetype", (Object)"json"), TuplesKt.to((Object)"file", (Object)node)});
        String dataStr = gson.toJson((Object)data);
        String string = this.client.getHost() + "/api/v2/orgs/import";
        String string2 = dataStr;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dataStr");
        return this.client.createHttpPostCall$core(string, string2, (TypeToken)new TypeToken<RestfulResponse<OrgNode>>(){}, importByJson.2.INSTANCE);
    }

    @NotNull
    public final HttpCall<RestfulResponse<List<OrgNode>>, List<OrgNode>> exportAll() {
        return this.client.createHttpGetCall$core(this.client.getHost() + "/api/v2/orgs/export", (TypeToken)new TypeToken<RestfulResponse<List<? extends OrgNode>>>(){}, exportAll.2.INSTANCE);
    }

    @NotNull
    public final HttpCall<RestfulResponse<OrgNode>, OrgNode> exportByOrgId(@NotNull String orgId) {
        Intrinsics.checkParameterIsNotNull((Object)orgId, (String)"orgId");
        return this.client.createHttpGetCall$core(this.client.getHost() + "/api/v2/orgs/export?org_id=" + orgId, (TypeToken)new TypeToken<RestfulResponse<OrgNode>>(){}, exportByOrgId.2.INSTANCE);
    }

    @NotNull
    public final GraphQLCall<ListNodeByCodeAuthorizedResourcesResponse, Node> listAuthorizedResourcesByNodeId(@NotNull ListNodeByIdAuthorizedResourcesParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.client.createGraphQLCall$core(param.createRequest(), (TypeToken)new TypeToken<GraphQLResponse<ListNodeByCodeAuthorizedResourcesResponse>>(){}, listAuthorizedResourcesByNodeId.2.INSTANCE);
    }

    public OrgManagementClient(@NotNull ManagementClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
    }
}

