/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastdata.vbapi.hash;

import cn.com.vastdata.vbapi.utils.VBStringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Timestamp;

public class BaseHash {
    private static final long INT_MASK = 0xFFFFFFFFL;
    private static final long BYTE_MASK = 255L;
    private static final long POSTGRES_EPOCH_JDATE = 2451545L;
    private static final long USECS_PER_SEC = 1000000L;
    private static final long USECS_PER_DAY = 86400000000L;
    private static final int MINS_PER_HOUR = 60;
    private static final int SECS_PER_MINUTE = 60;
    private static int UINT32_SIZE = 4;
    private static int DOUBLE_SIZE = 8;

    public static long hashInt1(byte b) {
        if (b < 0) {
            throw new RuntimeException("tinyint is unsupport value below 0");
        }
        return BaseHash.hashUint32(b);
    }

    public static long hashInt2(short s) {
        return BaseHash.hashUint32(s);
    }

    public static long hashInt4(int i) {
        return BaseHash.hashUint32(i);
    }

    public static long hashInt8(long k) {
        long m = k;
        long lohalf = m & 0xFFFFFFFFL;
        long hihalf = m >> 32 & 0xFFFFFFFFL;
        return BaseHash.hashUint32(lohalf ^= m >= 0L ? hihalf : hihalf ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long hashFloat4(float f) {
        if (f == 0.0f) {
            return 0L;
        }
        double key = f;
        return BaseHash.hashAny(BaseHash.getByteArray(Double.doubleToLongBits(key)), DOUBLE_SIZE);
    }

    public static long hashFloat8(double d) {
        if (d == 0.0) {
            return 0L;
        }
        return BaseHash.hashAny(BaseHash.getByteArray(Double.doubleToLongBits(d)), DOUBLE_SIZE);
    }

    public static long vbHashVarlena(String s, String charsetName) throws UnsupportedEncodingException {
        if (s == null || s.length() == 0) {
            return 0L;
        }
        s = VBStringUtils.rTrim(s);
        byte[] bytes = charsetName != null ? s.getBytes(charsetName) : s.getBytes();
        return BaseHash.hashAny(bytes, bytes.length);
    }

    public static long hashTimeStamp(Timestamp t) {
        long time;
        if (t == null) {
            return 0L;
        }
        long date = (long)BaseHash.date2j(t.getYear() + 1900, t.getMonth() + 1, t.getDate()) - 2451545L;
        long ret = date * 86400000000L + (time = BaseHash.time2t(t.getHours(), t.getMinutes(), t.getSeconds(), t.getNanos() / 1000));
        if ((ret - time) / 86400000000L != date) {
            ret = 0L;
        }
        if (ret < 0L && date > 0L || ret > 0L && date < -1L) {
            ret = 0L;
        }
        return BaseHash.hashInt8(ret);
    }

    public static long hashDate(Date key) {
        if (key == null) {
            return 0L;
        }
        Timestamp timestamp = new Timestamp(key.getTime());
        return BaseHash.hashTimeStamp(timestamp);
    }

    public static long hashUint32(long k) {
        long c;
        long b = c = 2654435769L + (long)UINT32_SIZE + 3923095L;
        long a = c;
        return BaseHash.final32(a += k, b, c)[2];
    }

    public static long hashAny(byte[] key, int keyLen) {
        int len;
        long c;
        long b = c = 2654435769L + (long)len + 3923095L;
        long a = c;
        int offset = 0;
        for (len = keyLen; len >= 12; len -= 12) {
            a = a + ((long)key[offset + 0] & 0xFFL) & 0xFFFFFFFFL;
            a = a + (((long)key[offset + 1] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            a = a + (((long)key[offset + 2] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            a = a + (((long)key[offset + 3] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            b = b + ((long)key[offset + 4] & 0xFFL) & 0xFFFFFFFFL;
            b = b + (((long)key[offset + 5] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            b = b + (((long)key[offset + 6] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            b = b + (((long)key[offset + 7] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            c = c + ((long)key[offset + 8] & 0xFFL) & 0xFFFFFFFFL;
            c = c + (((long)key[offset + 9] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            c = c + (((long)key[offset + 10] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            c = c + (((long)key[offset + 11] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            long[] rtMix32 = BaseHash.mix32(a, b, c);
            a = rtMix32[0];
            b = rtMix32[1];
            c = rtMix32[2];
            offset += 12;
        }
        switch (len) {
            case 11: {
                c = c + (((long)key[offset + 10] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 10: {
                c = c + (((long)key[offset + 9] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 9: {
                c = c + (((long)key[offset + 8] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 8: {
                b = b + (((long)key[offset + 7] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 7: {
                b = b + (((long)key[offset + 6] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 6: {
                b = b + (((long)key[offset + 5] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 5: {
                b = b + ((long)key[offset + 4] & 0xFFL) & 0xFFFFFFFFL;
            }
            case 4: {
                a = a + (((long)key[offset + 3] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 3: {
                a = a + (((long)key[offset + 2] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 2: {
                a = a + (((long)key[offset + 1] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 1: {
                a = a + ((long)key[offset + 0] & 0xFFL) & 0xFFFFFFFFL;
            }
        }
        return BaseHash.final32(a, b, c)[2];
    }

    public static byte[] getByteArray(long l) {
        byte[] b = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)};
        return b;
    }

    private static long[] final32(long a, long b, long c) {
        long[] rt = new long[3];
        c ^= b;
        c = c - BaseHash.rot(b, 14) & 0xFFFFFFFFL;
        a ^= c;
        a = a - BaseHash.rot(c, 11) & 0xFFFFFFFFL;
        b ^= a;
        b = b - BaseHash.rot(a, 25) & 0xFFFFFFFFL;
        c ^= b;
        c = c - BaseHash.rot(b, 16) & 0xFFFFFFFFL;
        a ^= c;
        a = a - BaseHash.rot(c, 4) & 0xFFFFFFFFL;
        b ^= a;
        b = b - BaseHash.rot(a, 14) & 0xFFFFFFFFL;
        c ^= b;
        c = c - BaseHash.rot(b, 24) & 0xFFFFFFFFL;
        rt[0] = a & 0xFFFFFFFFL;
        rt[1] = b & 0xFFFFFFFFL;
        rt[2] = c & 0xFFFFFFFFL;
        return rt;
    }

    private static long[] mix32(Long a, Long b, Long c) {
        long[] rt = new long[3];
        a = a - c & 0xFFFFFFFFL;
        a = a ^ BaseHash.rot(c, 4);
        c = c + b & 0xFFFFFFFFL;
        b = b - a & 0xFFFFFFFFL;
        b = b ^ BaseHash.rot(a, 6);
        a = a + c & 0xFFFFFFFFL;
        c = c - b & 0xFFFFFFFFL;
        c = c ^ BaseHash.rot(b, 8);
        b = b + a & 0xFFFFFFFFL;
        a = a - c & 0xFFFFFFFFL;
        a = a ^ BaseHash.rot(c, 16);
        c = c + b & 0xFFFFFFFFL;
        b = b - a & 0xFFFFFFFFL;
        b = b ^ BaseHash.rot(a, 19);
        a = a + c & 0xFFFFFFFFL;
        c = c - b & 0xFFFFFFFFL;
        c = c ^ BaseHash.rot(b, 4);
        b = b + a & 0xFFFFFFFFL;
        rt[0] = a & 0xFFFFFFFFL;
        rt[1] = b & 0xFFFFFFFFL;
        rt[2] = c & 0xFFFFFFFFL;
        return rt;
    }

    private static long rot(long val, int pos) {
        return (long)Integer.rotateLeft((int)(val & 0xFFFFFFFFL), pos) & 0xFFFFFFFFL;
    }

    private static int date2j(int year, int mouth, int day) {
        if (mouth > 2) {
            ++mouth;
            year += 4800;
        } else {
            mouth += 13;
            year += 4799;
        }
        int century = year / 100;
        int julian = year * 365 - 32167;
        julian += year / 4 - century + century / 4;
        return julian += 7834 * mouth / 256 + day;
    }

    private static long time2t(int hour, int min, int sec, int fsec) {
        return (long)((hour * 60 + min) * 60 + sec) * 1000000L + (long)fsec;
    }
}

