/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.bulkload;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;
import org.postgresql.bulkload.BulkloadManager;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class BulkloadFileHandler {
    private final BulkloadManager bulkloadAPI;

    public BulkloadFileHandler(BulkloadManager bulkloadAPI) {
        this.bulkloadAPI = bulkloadAPI;
    }

    public File[] getFilesFromFolder(String folderPath, final Pattern fileNamePattern) throws PSQLException {
        if (folderPath == null) {
            throw new PSQLException("the folderPath could not be null.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        File folder = new File(folderPath);
        if (!folder.exists()) {
            throw new PSQLException("the folderPath : \"" + folderPath + "\" is not exists.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (!folder.isDirectory()) {
            throw new PSQLException("the folderPath : \"" + folderPath + "\" is not a folder.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File item) {
                return !item.isDirectory() && item.getName().matches(fileNamePattern.pattern());
            }
        };
        return folder.listFiles(fileFilter);
    }

    public BulkloadManager getBulkloadAPI() {
        return this.bulkloadAPI;
    }
}

