/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.action;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.action.SaTokenAction;
import cn.dev33.satoken.annotation.SaCheckLogin;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaCheckSafe;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.util.SaFoxUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;

public class SaTokenActionDefaultImpl
implements SaTokenAction {
    @Override
    public String createToken(Object loginId, String loginType) {
        String tokenStyle = SaManager.getConfig().getTokenStyle();
        if ("uuid".equals(tokenStyle)) {
            return UUID.randomUUID().toString();
        }
        if ("simple-uuid".equals(tokenStyle)) {
            return UUID.randomUUID().toString().replaceAll("-", "");
        }
        if ("random-32".equals(tokenStyle)) {
            return SaFoxUtil.getRandomString(32);
        }
        if ("random-64".equals(tokenStyle)) {
            return SaFoxUtil.getRandomString(64);
        }
        if ("random-128".equals(tokenStyle)) {
            return SaFoxUtil.getRandomString(128);
        }
        if ("tik".equals(tokenStyle)) {
            return SaFoxUtil.getRandomString(2) + "_" + SaFoxUtil.getRandomString(14) + "_" + SaFoxUtil.getRandomString(16) + "__";
        }
        return UUID.randomUUID().toString();
    }

    @Override
    public SaSession createSession(String sessionId) {
        return new SaSession(sessionId);
    }

    @Override
    public boolean hasElement(List<String> list, String element) {
        if (list == null || list.size() == 0) {
            return false;
        }
        if (list.contains(element)) {
            return true;
        }
        for (String patt : list) {
            if (!SaFoxUtil.vagueMatch(patt, element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkMethodAnnotation(Method method) {
        this.validateAnnotation(method.getDeclaringClass());
        this.validateAnnotation(method);
    }

    protected void validateAnnotation(AnnotatedElement target) {
        Annotation at;
        if (target.isAnnotationPresent(SaCheckLogin.class)) {
            at = target.getAnnotation(SaCheckLogin.class);
            SaManager.getStpLogic(at.type()).checkByAnnotation((SaCheckLogin)at);
        }
        if (target.isAnnotationPresent(SaCheckRole.class)) {
            at = target.getAnnotation(SaCheckRole.class);
            SaManager.getStpLogic(at.type()).checkByAnnotation((SaCheckRole)at);
        }
        if (target.isAnnotationPresent(SaCheckPermission.class)) {
            at = target.getAnnotation(SaCheckPermission.class);
            SaManager.getStpLogic(at.type()).checkByAnnotation((SaCheckPermission)at);
        }
        if (target.isAnnotationPresent(SaCheckSafe.class)) {
            at = target.getAnnotation(SaCheckSafe.class);
            SaManager.getStpLogic(null).checkByAnnotation((SaCheckSafe)at);
        }
    }
}

