/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.stp;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.annotation.SaCheckLogin;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaCheckSafe;
import cn.dev33.satoken.annotation.SaMode;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.context.model.SaStorage;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.exception.DisableLoginException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.dev33.satoken.exception.NotSafeException;
import cn.dev33.satoken.fun.SaFunction;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.session.TokenSign;
import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class StpLogic {
    public String loginType;

    public StpLogic(String loginType) {
        this.loginType = loginType;
        SaManager.putStpLogic(this);
    }

    public String getLoginType() {
        return this.loginType;
    }

    public StpLogic setLoginType(String loginType) {
        this.loginType = loginType;
        return this;
    }

    public String getTokenName() {
        return this.splicingKeyTokenName();
    }

    public String createTokenValue(Object loginId) {
        return SaManager.getSaTokenAction().createToken(loginId, this.loginType);
    }

    public void setTokenValue(String tokenValue, int cookieTimeout) {
        SaTokenConfig config = this.getConfig();
        SaStorage storage = SaHolder.getStorage();
        String tokenPrefix = config.getTokenPrefix();
        if (SaFoxUtil.isEmpty(tokenPrefix)) {
            storage.set(this.splicingKeyJustCreatedSave(), tokenValue);
        } else {
            storage.set(this.splicingKeyJustCreatedSave(), tokenPrefix + " " + tokenValue);
        }
        if (config.getIsReadCookie().booleanValue()) {
            SaResponse response = SaHolder.getResponse();
            response.addCookie(this.getTokenName(), tokenValue, "/", config.getCookieDomain(), cookieTimeout);
        }
    }

    public String getTokenValue() {
        String tokenPrefix;
        SaStorage storage = SaHolder.getStorage();
        SaRequest request = SaHolder.getRequest();
        SaTokenConfig config = this.getConfig();
        String keyTokenName = this.getTokenName();
        String tokenValue = null;
        if (storage.get(this.splicingKeyJustCreatedSave()) != null) {
            tokenValue = String.valueOf(storage.get(this.splicingKeyJustCreatedSave()));
        }
        if (tokenValue == null && config.getIsReadBody().booleanValue()) {
            tokenValue = request.getParam(keyTokenName);
        }
        if (tokenValue == null && config.getIsReadHead().booleanValue()) {
            tokenValue = request.getHeader(keyTokenName);
        }
        if (tokenValue == null && config.getIsReadCookie().booleanValue()) {
            tokenValue = request.getCookieValue(keyTokenName);
        }
        if (!SaFoxUtil.isEmpty(tokenPrefix = this.getConfig().getTokenPrefix()) && !SaFoxUtil.isEmpty(tokenValue)) {
            tokenValue = tokenValue.startsWith(tokenPrefix + " ") ? tokenValue.substring(tokenPrefix.length() + " ".length()) : null;
        }
        return tokenValue;
    }

    public SaTokenInfo getTokenInfo() {
        SaTokenInfo info = new SaTokenInfo();
        info.tokenName = this.getTokenName();
        info.tokenValue = this.getTokenValue();
        info.isLogin = this.isLogin();
        info.loginId = this.getLoginIdDefaultNull();
        info.loginType = this.getLoginType();
        info.tokenTimeout = this.getTokenTimeout();
        info.sessionTimeout = this.getSessionTimeout();
        info.tokenSessionTimeout = this.getTokenSessionTimeout();
        info.tokenActivityTimeout = this.getTokenActivityTimeout();
        info.loginDevice = this.getLoginDevice();
        return info;
    }

    public void login(Object id) {
        this.login(id, new SaLoginModel());
    }

    public void login(Object id, String device) {
        this.login(id, new SaLoginModel().setDevice(device));
    }

    public void login(Object id, boolean isLastingCookie) {
        this.login(id, new SaLoginModel().setIsLastingCookie(isLastingCookie));
    }

    public void login(Object id, SaLoginModel loginModel) {
        SaSession session;
        if (this.isDisable(id)) {
            throw new DisableLoginException(this.loginType, id, this.getDisableTime(id));
        }
        SaTokenConfig config = this.getConfig();
        SaTokenDao dao = SaManager.getSaTokenDao();
        loginModel.build(config);
        String tokenValue = null;
        if (config.getIsConcurrent().booleanValue()) {
            if (config.getIsShare().booleanValue()) {
                tokenValue = this.getTokenValueByLoginId(id, loginModel.getDevice());
            }
        } else {
            session = this.getSessionByLoginId(id, false);
            if (session != null) {
                List<TokenSign> tokenSignList = session.getTokenSignList();
                for (TokenSign tokenSign : tokenSignList) {
                    if (!tokenSign.getDevice().equals(loginModel.getDevice())) continue;
                    dao.update(this.splicingKeyTokenValue(tokenSign.getValue()), "-4");
                    this.clearLastActivity(tokenSign.getValue());
                    session.removeTokenSign(tokenSign.getValue());
                    SaManager.getSaTokenListener().doReplaced(this.loginType, id, tokenSign.getValue(), tokenSign.getDevice());
                }
            }
        }
        if (tokenValue == null) {
            tokenValue = this.createTokenValue(id);
        }
        session = this.getSessionByLoginId(id, true);
        session.updateMinTimeout(loginModel.getTimeout());
        session.addTokenSign(new TokenSign(tokenValue, loginModel.getDevice()));
        dao.set(this.splicingKeyTokenValue(tokenValue), String.valueOf(id), loginModel.getTimeout());
        this.setLastActivityToNow(tokenValue);
        this.setTokenValue(tokenValue, loginModel.getCookieTimeout());
        SaManager.getSaTokenListener().doLogin(this.loginType, id, loginModel);
    }

    public void logout() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return;
        }
        if (this.getConfig().getIsReadCookie().booleanValue()) {
            SaHolder.getResponse().deleteCookie(this.getTokenName());
        }
        this.logoutByTokenValue(tokenValue);
    }

    public void logoutByTokenValue(String tokenValue) {
        this.clearLastActivity(tokenValue);
        SaManager.getSaTokenDao().delete(this.splicingKeyTokenSession(tokenValue));
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId == null || NotLoginException.ABNORMAL_LIST.contains(loginId)) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingKeyTokenValue(tokenValue));
        SaManager.getSaTokenListener().doLogout(this.loginType, loginId, tokenValue);
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session == null) {
            return;
        }
        session.removeTokenSign(tokenValue);
        session.logoutByTokenSignCountToZero();
    }

    public void logoutByLoginId(Object loginId) {
        this.logoutByLoginId(loginId, null);
    }

    public void logoutByLoginId(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session == null) {
            return;
        }
        List<TokenSign> tokenSignList = session.getTokenSignList();
        for (TokenSign tokenSign : tokenSignList) {
            if (device != null && !tokenSign.getDevice().equals(device)) continue;
            String tokenValue = tokenSign.getValue();
            this.clearLastActivity(tokenValue);
            SaManager.getSaTokenDao().update(this.splicingKeyTokenValue(tokenValue), "-5");
            session.removeTokenSign(tokenValue);
            SaManager.getSaTokenListener().doLogoutByLoginId(this.loginType, loginId, tokenValue, tokenSign.getDevice());
        }
        session.logoutByTokenSignCountToZero();
    }

    public boolean isLogin() {
        return this.getLoginIdDefaultNull() != null;
    }

    public void checkLogin() {
        this.getLoginId();
    }

    public Object getLoginId() {
        if (this.isSwitch()) {
            return this.getSwitchLoginId();
        }
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            throw NotLoginException.newInstance(this.loginType, "-1");
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId == null) {
            throw NotLoginException.newInstance(this.loginType, "-2");
        }
        if (loginId.equals("-3")) {
            throw NotLoginException.newInstance(this.loginType, "-3");
        }
        if (loginId.equals("-4")) {
            throw NotLoginException.newInstance(this.loginType, "-4");
        }
        if (loginId.equals("-5")) {
            throw NotLoginException.newInstance(this.loginType, "-5");
        }
        this.checkActivityTimeout(tokenValue);
        if (this.getConfig().getAutoRenew().booleanValue()) {
            this.updateLastActivityToNow(tokenValue);
        }
        return loginId;
    }

    public <T> T getLoginId(T defaultValue) {
        Object loginId = this.getLoginIdDefaultNull();
        if (loginId == null) {
            return defaultValue;
        }
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(loginId.toString());
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(loginId.toString());
        }
        if (defaultValue instanceof String) {
            return (T)loginId.toString();
        }
        return (T)loginId;
    }

    public Object getLoginIdDefaultNull() {
        if (this.isSwitch()) {
            return this.getSwitchLoginId();
        }
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId == null || NotLoginException.ABNORMAL_LIST.contains(loginId)) {
            return null;
        }
        if (this.getTokenActivityTimeoutByToken(tokenValue) == -2L) {
            return null;
        }
        return loginId;
    }

    public String getLoginIdAsString() {
        return String.valueOf(this.getLoginId());
    }

    public int getLoginIdAsInt() {
        return Integer.parseInt(String.valueOf(this.getLoginId()));
    }

    public long getLoginIdAsLong() {
        return Long.parseLong(String.valueOf(this.getLoginId()));
    }

    public Object getLoginIdByToken(String tokenValue) {
        if (tokenValue == null) {
            return null;
        }
        return this.getLoginIdNotHandle(tokenValue);
    }

    public String getLoginIdNotHandle(String tokenValue) {
        return SaManager.getSaTokenDao().get(this.splicingKeyTokenValue(tokenValue));
    }

    public SaSession getSessionBySessionId(String sessionId, boolean isCreate) {
        SaSession session = SaManager.getSaTokenDao().getSession(sessionId);
        if (session == null && isCreate) {
            session = SaManager.getSaTokenAction().createSession(sessionId);
            SaManager.getSaTokenDao().setSession(session, this.getConfig().getTimeout());
        }
        return session;
    }

    public SaSession getSessionBySessionId(String sessionId) {
        return this.getSessionBySessionId(sessionId, false);
    }

    public SaSession getSessionByLoginId(Object loginId, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeySession(loginId), isCreate);
    }

    public SaSession getSessionByLoginId(Object loginId) {
        return this.getSessionByLoginId(loginId, true);
    }

    public SaSession getSession(boolean isCreate) {
        return this.getSessionByLoginId(this.getLoginId(), isCreate);
    }

    public SaSession getSession() {
        return this.getSession(true);
    }

    public SaSession getTokenSessionByToken(String tokenValue, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeyTokenSession(tokenValue), isCreate);
    }

    public SaSession getTokenSessionByToken(String tokenValue) {
        return this.getSessionBySessionId(this.splicingKeyTokenSession(tokenValue), true);
    }

    public SaSession getTokenSession(boolean isCreate) {
        if (this.getConfig().getTokenSessionCheckLogin().booleanValue()) {
            this.checkLogin();
        } else {
            String tokenValue = this.getTokenValue();
            if (tokenValue == null || Objects.equals(tokenValue, "")) {
                tokenValue = this.createTokenValue(null);
                this.setLastActivityToNow(tokenValue);
                int cookieTimeout = (int)(this.getConfig().getTimeout() == -1L ? Integer.MAX_VALUE : this.getConfig().getTimeout());
                this.setTokenValue(tokenValue, cookieTimeout);
            }
        }
        return this.getSessionBySessionId(this.splicingKeyTokenSession(this.getTokenValue()), isCreate);
    }

    public SaSession getTokenSession() {
        return this.getTokenSession(true);
    }

    protected void setLastActivityToNow(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SaManager.getSaTokenDao().set(this.splicingKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()), this.getConfig().getTimeout());
    }

    protected void clearLastActivity(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingKeyLastActivityTime(tokenValue));
        SaHolder.getStorage().delete("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_");
    }

    public void checkActivityTimeout(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SaStorage storage = SaHolder.getStorage();
        if (storage.get("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_") != null) {
            return;
        }
        long timeout = this.getTokenActivityTimeoutByToken(tokenValue);
        if (timeout == -1L) {
            return;
        }
        if (timeout == -2L) {
            throw NotLoginException.newInstance(this.loginType, "-3");
        }
        storage.set("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_", true);
    }

    public void checkActivityTimeout() {
        this.checkActivityTimeout(this.getTokenValue());
    }

    public void updateLastActivityToNow(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SaManager.getSaTokenDao().update(this.splicingKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()));
    }

    public void updateLastActivityToNow() {
        this.updateLastActivityToNow(this.getTokenValue());
    }

    public long getTokenTimeout() {
        return SaManager.getSaTokenDao().getTimeout(this.splicingKeyTokenValue(this.getTokenValue()));
    }

    public long getTokenTimeoutByLoginId(Object loginId) {
        return SaManager.getSaTokenDao().getTimeout(this.splicingKeyTokenValue(this.getTokenValueByLoginId(loginId)));
    }

    public long getSessionTimeout() {
        return this.getSessionTimeoutByLoginId(this.getLoginIdDefaultNull());
    }

    public long getSessionTimeoutByLoginId(Object loginId) {
        return SaManager.getSaTokenDao().getSessionTimeout(this.splicingKeySession(loginId));
    }

    public long getTokenSessionTimeout() {
        return this.getTokenSessionTimeoutByTokenValue(this.getTokenValue());
    }

    public long getTokenSessionTimeoutByTokenValue(String tokenValue) {
        return SaManager.getSaTokenDao().getSessionTimeout(this.splicingKeyTokenSession(tokenValue));
    }

    public long getTokenActivityTimeout() {
        return this.getTokenActivityTimeoutByToken(this.getTokenValue());
    }

    public long getTokenActivityTimeoutByToken(String tokenValue) {
        if (tokenValue == null) {
            return -2L;
        }
        if (this.getConfig().getActivityTimeout() == -1L) {
            return -1L;
        }
        String keyLastActivityTime = this.splicingKeyLastActivityTime(tokenValue);
        String lastActivityTimeString = SaManager.getSaTokenDao().get(keyLastActivityTime);
        if (lastActivityTimeString == null) {
            return -2L;
        }
        long lastActivityTime = Long.parseLong(lastActivityTimeString);
        long apartSecond = (System.currentTimeMillis() - lastActivityTime) / 1000L;
        long timeout = this.getConfig().getActivityTimeout() - apartSecond;
        if (timeout < 0L) {
            return -2L;
        }
        return timeout;
    }

    public boolean hasRole(Object loginId, String role) {
        List<String> roleList = SaManager.getStpInterface().getRoleList(loginId, this.loginType);
        return SaManager.getSaTokenAction().hasElement(roleList, role);
    }

    public boolean hasRole(String role) {
        return this.hasRole(this.getLoginId(), role);
    }

    public void checkRole(String role) {
        if (!this.hasRole(role)) {
            throw new NotRoleException(role, this.loginType);
        }
    }

    public void checkRoleAnd(String ... roleArray) {
        Object loginId = this.getLoginId();
        List<String> roleList = SaManager.getStpInterface().getRoleList(loginId, this.loginType);
        for (String role : roleArray) {
            if (SaManager.getSaTokenAction().hasElement(roleList, role)) continue;
            throw new NotRoleException(role, this.loginType);
        }
    }

    public void checkRoleOr(String ... roleArray) {
        Object loginId = this.getLoginId();
        List<String> roleList = SaManager.getStpInterface().getRoleList(loginId, this.loginType);
        for (String role : roleArray) {
            if (!SaManager.getSaTokenAction().hasElement(roleList, role)) continue;
            return;
        }
        if (roleArray.length > 0) {
            throw new NotRoleException(roleArray[0], this.loginType);
        }
    }

    public boolean hasPermission(Object loginId, String permission) {
        List<String> permissionList = SaManager.getStpInterface().getPermissionList(loginId, this.loginType);
        return SaManager.getSaTokenAction().hasElement(permissionList, permission);
    }

    public boolean hasPermission(String permission) {
        return this.hasPermission(this.getLoginId(), permission);
    }

    public void checkPermission(String permission) {
        if (!this.hasPermission(permission)) {
            throw new NotPermissionException(permission, this.loginType);
        }
    }

    public void checkPermissionAnd(String ... permissionArray) {
        Object loginId = this.getLoginId();
        List<String> permissionList = SaManager.getStpInterface().getPermissionList(loginId, this.loginType);
        for (String permission : permissionArray) {
            if (SaManager.getSaTokenAction().hasElement(permissionList, permission)) continue;
            throw new NotPermissionException(permission, this.loginType);
        }
    }

    public void checkPermissionOr(String ... permissionArray) {
        Object loginId = this.getLoginId();
        List<String> permissionList = SaManager.getStpInterface().getPermissionList(loginId, this.loginType);
        for (String permission : permissionArray) {
            if (!SaManager.getSaTokenAction().hasElement(permissionList, permission)) continue;
            return;
        }
        if (permissionArray.length > 0) {
            throw new NotPermissionException(permissionArray[0], this.loginType);
        }
    }

    public String getTokenValueByLoginId(Object loginId) {
        return this.getTokenValueByLoginId(loginId, "default-device");
    }

    public String getTokenValueByLoginId(Object loginId, String device) {
        List<String> tokenValueList = this.getTokenValueListByLoginId(loginId, device);
        return tokenValueList.size() == 0 ? null : tokenValueList.get(tokenValueList.size() - 1);
    }

    public List<String> getTokenValueListByLoginId(Object loginId) {
        return this.getTokenValueListByLoginId(loginId, "default-device");
    }

    public List<String> getTokenValueListByLoginId(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session == null) {
            return Collections.emptyList();
        }
        List<TokenSign> tokenSignList = session.getTokenSignList();
        ArrayList<String> tokenValueList = new ArrayList<String>();
        for (TokenSign tokenSign : tokenSignList) {
            if (!tokenSign.getDevice().equals(device)) continue;
            tokenValueList.add(tokenSign.getValue());
        }
        return tokenValueList;
    }

    public String getLoginDevice() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        if (!this.isLogin()) {
            return null;
        }
        SaSession session = this.getSessionByLoginId(this.getLoginIdDefaultNull(), false);
        if (session == null) {
            return null;
        }
        List<TokenSign> tokenSignList = session.getTokenSignList();
        for (TokenSign tokenSign : tokenSignList) {
            if (!tokenSign.getValue().equals(tokenValue)) continue;
            return tokenSign.getDevice();
        }
        return null;
    }

    public List<String> searchTokenValue(String keyword, int start, int size) {
        return SaManager.getSaTokenDao().searchData(this.splicingKeyTokenValue(""), keyword, start, size);
    }

    public List<String> searchSessionId(String keyword, int start, int size) {
        return SaManager.getSaTokenDao().searchData(this.splicingKeySession(""), keyword, start, size);
    }

    public List<String> searchTokenSessionId(String keyword, int start, int size) {
        return SaManager.getSaTokenDao().searchData(this.splicingKeyTokenSession(""), keyword, start, size);
    }

    public void checkByAnnotation(SaCheckLogin at) {
        this.checkLogin();
    }

    public void checkByAnnotation(SaCheckRole at) {
        String[] roleArray = at.value();
        if (at.mode() == SaMode.AND) {
            this.checkRoleAnd(roleArray);
        } else {
            this.checkRoleOr(roleArray);
        }
    }

    public void checkByAnnotation(SaCheckPermission at) {
        String[] permissionArray = at.value();
        if (at.mode() == SaMode.AND) {
            this.checkPermissionAnd(permissionArray);
        } else {
            this.checkPermissionOr(permissionArray);
        }
    }

    public void checkByAnnotation(SaCheckSafe at) {
        this.checkSafe();
    }

    public void disable(Object loginId, long disableTime) {
        SaManager.getSaTokenDao().set(this.splicingKeyDisable(loginId), "disable", disableTime);
        SaManager.getSaTokenListener().doDisable(this.loginType, loginId, disableTime);
    }

    public boolean isDisable(Object loginId) {
        return SaManager.getSaTokenDao().get(this.splicingKeyDisable(loginId)) != null;
    }

    public long getDisableTime(Object loginId) {
        return SaManager.getSaTokenDao().getTimeout(this.splicingKeyDisable(loginId));
    }

    public void untieDisable(Object loginId) {
        SaManager.getSaTokenDao().delete(this.splicingKeyDisable(loginId));
        SaManager.getSaTokenListener().doUntieDisable(this.loginType, loginId);
    }

    public void switchTo(Object loginId) {
        SaHolder.getStorage().set(this.splicingKeySwitch(), loginId);
    }

    public void endSwitch() {
        SaHolder.getStorage().delete(this.splicingKeySwitch());
    }

    public boolean isSwitch() {
        return SaHolder.getStorage().get(this.splicingKeySwitch()) != null;
    }

    public Object getSwitchLoginId() {
        return SaHolder.getStorage().get(this.splicingKeySwitch());
    }

    public void switchTo(Object loginId, SaFunction function) {
        try {
            this.switchTo(loginId);
            function.run();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.endSwitch();
        }
    }

    public void openSafe(long safeTime) {
        long eff = System.currentTimeMillis() + safeTime * 1000L;
        this.getTokenSession().set("SAFE_AUTH_SAVE_KEY_", eff);
    }

    public boolean isSafe() {
        long eff = this.getTokenSession().get("SAFE_AUTH_SAVE_KEY_", 0L);
        return eff != 0L && eff >= System.currentTimeMillis();
    }

    public void checkSafe() {
        if (!this.isSafe()) {
            throw new NotSafeException();
        }
    }

    public long getSafeTime() {
        long eff = this.getTokenSession().get("SAFE_AUTH_SAVE_KEY_", 0L);
        if (eff == 0L || eff < System.currentTimeMillis()) {
            return -2L;
        }
        return (eff - System.currentTimeMillis()) / 1000L;
    }

    public void closeSafe() {
        this.getTokenSession().delete("SAFE_AUTH_SAVE_KEY_");
    }

    public String splicingKeyTokenName() {
        return this.getConfig().getTokenName();
    }

    public String splicingKeyTokenValue(String tokenValue) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":token:" + tokenValue;
    }

    public String splicingKeySession(Object loginId) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":session:" + loginId;
    }

    public String splicingKeyTokenSession(String tokenValue) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":token-session:" + tokenValue;
    }

    public String splicingKeyLastActivityTime(String tokenValue) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":last-activity:" + tokenValue;
    }

    public String splicingKeySwitch() {
        return "SWITCH_TO_SAVE_KEY_" + this.loginType;
    }

    public String splicingKeyJustCreatedSave() {
        return "JUST_CREATED_SAVE_KEY_" + this.loginType;
    }

    public String splicingKeyDisable(Object loginId) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":disable:" + loginId;
    }

    public SaTokenConfig getConfig() {
        return SaManager.getConfig();
    }
}

