/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaSsoConfig;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.sso.SaSsoConsts;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SaSsoTemplate {
    public StpLogic stpLogic;

    public SaSsoTemplate(StpLogic stpLogic) {
        this.stpLogic = stpLogic;
    }

    public String createTicket(Object loginId) {
        String ticket = this.randomTicket(loginId);
        long ticketTimeout = SaManager.getConfig().getSso().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingKeyTicketToId(ticket), String.valueOf(loginId), ticketTimeout);
        SaManager.getSaTokenDao().set(this.splicingKeyIdToTicket(loginId), String.valueOf(ticket), ticketTimeout);
        return ticket;
    }

    public void deleteTicket(String ticket) {
        Object loginId = this.getLoginId(ticket);
        if (loginId != null) {
            SaManager.getSaTokenDao().delete(this.splicingKeyTicketToId(ticket));
            SaManager.getSaTokenDao().delete(this.splicingKeyIdToTicket(loginId));
        }
    }

    public String buildRedirectUrl(Object loginId, String redirect) {
        this.checkRedirectUrl(redirect);
        String oldTicket = SaManager.getSaTokenDao().get(this.splicingKeyIdToTicket(loginId));
        if (oldTicket != null) {
            this.deleteTicket(oldTicket);
        }
        String ticket = this.createTicket(loginId);
        redirect = this.encodeBackParam(redirect);
        String redirectUrl = SaFoxUtil.joinParam(redirect, SaSsoConsts.ParamName.ticket, ticket);
        return redirectUrl;
    }

    public Object getLoginId(String ticket) {
        if (SaFoxUtil.isEmpty(ticket)) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingKeyTicketToId(ticket));
    }

    public <T> T getLoginId(String ticket, Class<T> cs) {
        return SaFoxUtil.getValueByType(this.getLoginId(ticket), cs);
    }

    public Object checkTicket(String ticket) {
        Object loginId = this.getLoginId(ticket);
        if (loginId != null) {
            this.deleteTicket(ticket);
        }
        return loginId;
    }

    public void checkRedirectUrl(String url) {
        if (!SaFoxUtil.isUrl(url)) {
            throw new SaTokenException("\u65e0\u6548\u56de\u8c03\u5730\u5740\uff1a" + url);
        }
        int qIndex = url.indexOf("?");
        if (qIndex != -1) {
            url = url.substring(0, qIndex);
        }
        String authUrl = SaManager.getConfig().getSso().getAllowUrl().replaceAll(" ", "");
        List<String> authUrlList = Arrays.asList(authUrl.split(","));
        if (!SaManager.getSaTokenAction().hasElement(authUrlList, url)) {
            throw new SaTokenException("\u975e\u6cd5\u56de\u8c03\u5730\u5740\uff1a" + url);
        }
    }

    public String buildServerAuthUrl(String clientLoginUrl, String back) {
        String serverUrl = SaManager.getConfig().getSso().getAuthUrl();
        back = back == null ? "" : back;
        back = SaFoxUtil.encodeUrl(back);
        clientLoginUrl = SaFoxUtil.joinParam(clientLoginUrl, SaSsoConsts.ParamName.back, back);
        String serverAuthUrl = SaFoxUtil.joinParam(serverUrl, SaSsoConsts.ParamName.redirect, clientLoginUrl);
        return serverAuthUrl;
    }

    public String encodeBackParam(String url) {
        int index = url.indexOf("?" + SaSsoConsts.ParamName.back + "=");
        if (index == -1 && (index = url.indexOf("&" + SaSsoConsts.ParamName.back + "=")) == -1) {
            return url;
        }
        int length = SaSsoConsts.ParamName.back.length() + 2;
        String back = url.substring(index + length);
        back = SaFoxUtil.encodeUrl(back);
        url = url.substring(0, index + length) + back;
        return url;
    }

    public String randomTicket(Object loginId) {
        return SaFoxUtil.getRandomString(64);
    }

    public void checkSecretkey(String secretkey) {
        if (secretkey == null || secretkey.isEmpty() || !secretkey.equals(SaManager.getConfig().getSso().getSecretkey())) {
            throw new SaTokenException("\u65e0\u6548\u79d8\u94a5\uff1a" + secretkey);
        }
    }

    public String buildCheckTicketUrl(String ticket, String ssoLogoutCallUrl) {
        String url = SaManager.getConfig().getSso().getCheckTicketUrl();
        url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.ticket, ticket);
        if (ssoLogoutCallUrl != null) {
            url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.ssoLogoutCall, ssoLogoutCallUrl);
        }
        return url;
    }

    public void registerSloCallbackUrl(Object loginId, String sloCallbackUrl) {
        if (loginId == null || sloCallbackUrl == null || sloCallbackUrl.isEmpty()) {
            return;
        }
        Set urlSet = (Set)this.stpLogic.getSessionByLoginId(loginId).get("SLO_CALLBACK_SET_KEY_", () -> new HashSet());
        urlSet.add(sloCallbackUrl);
        this.stpLogic.getSessionByLoginId(loginId).set("SLO_CALLBACK_SET_KEY_", urlSet);
    }

    public void forEachSloUrl(Object loginId, CallSloUrlFunction fun) {
        String secretkey = SaManager.getConfig().getSso().getSecretkey();
        Set urlSet = (Set)this.stpLogic.getSessionByLoginId(loginId).get("SLO_CALLBACK_SET_KEY_", () -> new HashSet());
        for (String url : urlSet) {
            url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.loginId, loginId);
            url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.secretkey, secretkey);
            fun.run(url);
        }
    }

    public String buildSloUrl(Object loginId) {
        SaSsoConfig ssoConfig = SaManager.getConfig().getSso();
        String url = ssoConfig.getSloUrl();
        url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.loginId, loginId);
        url = SaFoxUtil.joinParam(url, SaSsoConsts.ParamName.secretkey, ssoConfig.getSecretkey());
        return url;
    }

    public void singleLogout(String secretkey, Object loginId, CallSloUrlFunction fun) {
        this.checkSecretkey(secretkey);
        this.forEachSloUrl(loginId, fun);
        this.stpLogic.logoutByTokenValue(this.stpLogic.getTokenValueByLoginId(loginId));
    }

    public String splicingKeyTicketToId(String ticket) {
        return SaManager.getConfig().getTokenName() + ":ticket:" + ticket;
    }

    public String splicingKeyIdToTicket(Object id) {
        return SaManager.getConfig().getTokenName() + ":id-ticket:" + id;
    }

    @FunctionalInterface
    static interface CallSloUrlFunction {
        public void run(String var1);
    }
}

