/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor;

import cn.hippo4j.common.toolkit.CalculateUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalNotifyAlarmManage;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import cn.hippo4j.core.toolkit.IdentifyUtil;
import cn.hippo4j.core.toolkit.TraceContextUtil;
import cn.hippo4j.message.enums.NotifyTypeEnum;
import cn.hippo4j.message.request.AlarmNotifyRequest;
import cn.hippo4j.message.request.ChangeParameterNotifyRequest;
import cn.hippo4j.message.service.Hippo4jSendMessageService;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import cn.hutool.core.util.StrUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;

public class ThreadPoolNotifyAlarmHandler
implements Runnable,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolNotifyAlarmHandler.class);
    @NonNull
    private final Hippo4jSendMessageService hippoSendMessageService;
    @Value(value="${spring.profiles.active:UNKNOWN}")
    private String active;
    @Value(value="${spring.dynamic.thread-pool.item-id:}")
    private String itemId;
    @Value(value="${spring.application.name:UNKNOWN}")
    private String applicationName;
    @Value(value="${spring.dynamic.thread-pool.check-state-interval:5}")
    private Integer checkStateInterval;
    private final ScheduledExecutorService ALARM_NOTIFY_EXECUTOR = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "client.alarm.notify"));
    private final ExecutorService EXECUTE_TIMEOUT_EXECUTOR = ThreadPoolBuilder.builder().poolThreadSize(2, 4).threadFactory("client.execute.timeout.alarm").allowCoreThreadTimeOut(true).keepAliveTime(60L, TimeUnit.SECONDS).workQueue(new LinkedBlockingQueue(4096)).rejected(new ThreadPoolExecutor.AbortPolicy()).build();

    public void run(String ... args) throws Exception {
        this.ALARM_NOTIFY_EXECUTOR.scheduleWithFixedDelay(this, 0L, this.checkStateInterval.intValue(), TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        List<String> listThreadPoolId = GlobalThreadPoolManage.listThreadPoolId();
        listThreadPoolId.forEach(threadPoolId -> {
            ThreadPoolNotifyAlarm threadPoolNotifyAlarm = GlobalNotifyAlarmManage.get(threadPoolId);
            if (threadPoolNotifyAlarm != null && threadPoolNotifyAlarm.getAlarm().booleanValue()) {
                DynamicThreadPoolWrapper wrapper = GlobalThreadPoolManage.getExecutorService(threadPoolId);
                ThreadPoolExecutor executor = wrapper.getExecutor();
                this.checkPoolCapacityAlarm((String)threadPoolId, executor);
                this.checkPoolActivityAlarm((String)threadPoolId, executor);
            }
        });
    }

    public void checkPoolCapacityAlarm(String threadPoolId, ThreadPoolExecutor threadPoolExecutor) {
        boolean isSend;
        if (this.hippoSendMessageService == null) {
            return;
        }
        ThreadPoolNotifyAlarm threadPoolNotifyAlarm = GlobalNotifyAlarmManage.get(threadPoolId);
        BlockingQueue<Runnable> blockingQueue = threadPoolExecutor.getQueue();
        int queueSize = blockingQueue.size();
        int capacity = queueSize + blockingQueue.remainingCapacity();
        int divide = CalculateUtil.divide((int)queueSize, (int)capacity);
        boolean bl = isSend = threadPoolNotifyAlarm.getAlarm() != false && divide > threadPoolNotifyAlarm.getCapacityAlarm();
        if (isSend) {
            AlarmNotifyRequest alarmNotifyRequest = this.buildAlarmNotifyReq(threadPoolExecutor);
            alarmNotifyRequest.setThreadPoolId(threadPoolId);
            this.hippoSendMessageService.sendAlarmMessage(NotifyTypeEnum.CAPACITY, alarmNotifyRequest);
        }
    }

    public void checkPoolActivityAlarm(String threadPoolId, ThreadPoolExecutor threadPoolExecutor) {
        boolean isSend;
        int activeCount = threadPoolExecutor.getActiveCount();
        int maximumPoolSize = threadPoolExecutor.getMaximumPoolSize();
        int divide = CalculateUtil.divide((int)activeCount, (int)maximumPoolSize);
        ThreadPoolNotifyAlarm threadPoolNotifyAlarm = GlobalNotifyAlarmManage.get(threadPoolId);
        boolean bl = isSend = threadPoolNotifyAlarm.getAlarm() != false && divide > threadPoolNotifyAlarm.getActiveAlarm();
        if (isSend) {
            AlarmNotifyRequest alarmNotifyRequest = this.buildAlarmNotifyReq(threadPoolExecutor);
            alarmNotifyRequest.setThreadPoolId(threadPoolId);
            this.hippoSendMessageService.sendAlarmMessage(NotifyTypeEnum.ACTIVITY, alarmNotifyRequest);
        }
    }

    public void checkPoolRejectedAlarm(String threadPoolId) {
        ThreadPoolNotifyAlarm threadPoolNotifyAlarm = GlobalNotifyAlarmManage.get(threadPoolId);
        if (Objects.isNull(threadPoolNotifyAlarm) || !threadPoolNotifyAlarm.getAlarm().booleanValue()) {
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = GlobalThreadPoolManage.getExecutorService(threadPoolId).getExecutor();
        this.checkPoolRejectedAlarm(threadPoolId, threadPoolExecutor);
    }

    public void checkPoolRejectedAlarm(String threadPoolId, ThreadPoolExecutor threadPoolExecutor) {
        if (threadPoolExecutor instanceof DynamicThreadPoolExecutor) {
            AlarmNotifyRequest alarmNotifyRequest = this.buildAlarmNotifyReq(threadPoolExecutor);
            alarmNotifyRequest.setThreadPoolId(threadPoolId);
            this.hippoSendMessageService.sendAlarmMessage(NotifyTypeEnum.REJECT, alarmNotifyRequest);
        }
    }

    public void asyncSendExecuteTimeOutAlarm(String threadPoolId, long executeTime, long executeTimeOut, ThreadPoolExecutor threadPoolExecutor) {
        ThreadPoolNotifyAlarm threadPoolNotifyAlarm = GlobalNotifyAlarmManage.get(threadPoolId);
        if (Objects.isNull(threadPoolNotifyAlarm) || !threadPoolNotifyAlarm.getAlarm().booleanValue()) {
            return;
        }
        if (threadPoolExecutor instanceof DynamicThreadPoolExecutor) {
            try {
                AlarmNotifyRequest alarmNotifyRequest = this.buildAlarmNotifyReq(threadPoolExecutor);
                alarmNotifyRequest.setThreadPoolId(threadPoolId);
                alarmNotifyRequest.setExecuteTime(Long.valueOf(executeTime));
                alarmNotifyRequest.setExecuteTimeOut(Long.valueOf(executeTimeOut));
                String executeTimeoutTrace = TraceContextUtil.getAndRemove();
                if (StringUtil.isNotBlank((CharSequence)executeTimeoutTrace)) {
                    alarmNotifyRequest.setExecuteTimeoutTrace(executeTimeoutTrace);
                }
                Runnable task = () -> this.hippoSendMessageService.sendAlarmMessage(NotifyTypeEnum.TIMEOUT, alarmNotifyRequest);
                this.EXECUTE_TIMEOUT_EXECUTOR.execute(task);
            }
            catch (Throwable ex) {
                log.error("Send thread pool execution timeout alarm error.", ex);
            }
        }
    }

    public void sendPoolConfigChange(ChangeParameterNotifyRequest request) {
        request.setActive(this.active.toUpperCase());
        String appName = StrUtil.isBlank((CharSequence)this.itemId) ? this.applicationName : this.itemId;
        request.setAppName(appName);
        request.setIdentify(IdentifyUtil.getIdentify());
        this.hippoSendMessageService.sendChangeMessage(request);
    }

    public AlarmNotifyRequest buildAlarmNotifyReq(ThreadPoolExecutor threadPoolExecutor) {
        AlarmNotifyRequest request = new AlarmNotifyRequest();
        String appName = StrUtil.isBlank((CharSequence)this.itemId) ? this.applicationName : this.itemId;
        request.setAppName(appName);
        int corePoolSize = threadPoolExecutor.getCorePoolSize();
        int maximumPoolSize = threadPoolExecutor.getMaximumPoolSize();
        int poolSize = threadPoolExecutor.getPoolSize();
        int activeCount = threadPoolExecutor.getActiveCount();
        int largestPoolSize = threadPoolExecutor.getLargestPoolSize();
        long completedTaskCount = threadPoolExecutor.getCompletedTaskCount();
        request.setActive(this.active.toUpperCase());
        request.setIdentify(IdentifyUtil.getIdentify());
        request.setCorePoolSize(Integer.valueOf(corePoolSize));
        request.setMaximumPoolSize(Integer.valueOf(maximumPoolSize));
        request.setPoolSize(Integer.valueOf(poolSize));
        request.setActiveCount(Integer.valueOf(activeCount));
        request.setLargestPoolSize(Integer.valueOf(largestPoolSize));
        request.setCompletedTaskCount(Long.valueOf(completedTaskCount));
        BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
        int queueSize = queue.size();
        String queueType = queue.getClass().getSimpleName();
        int remainingCapacity = queue.remainingCapacity();
        int queueCapacity = queueSize + remainingCapacity;
        request.setQueueName(queueType);
        request.setCapacity(Integer.valueOf(queueCapacity));
        request.setQueueSize(Integer.valueOf(queueSize));
        request.setRemainingCapacity(Integer.valueOf(remainingCapacity));
        RejectedExecutionHandler rejectedExecutionHandler = threadPoolExecutor instanceof DynamicThreadPoolExecutor ? ((DynamicThreadPoolExecutor)threadPoolExecutor).getRedundancyHandler() : threadPoolExecutor.getRejectedExecutionHandler();
        request.setRejectedExecutionHandlerName(rejectedExecutionHandler.getClass().getSimpleName());
        long rejectCount = threadPoolExecutor instanceof DynamicThreadPoolExecutor ? ((DynamicThreadPoolExecutor)threadPoolExecutor).getRejectCountNum() : -1L;
        request.setRejectCountNum(Long.valueOf(rejectCount));
        return request;
    }

    public ThreadPoolNotifyAlarmHandler(@NonNull Hippo4jSendMessageService hippoSendMessageService) {
        if (hippoSendMessageService == null) {
            throw new NullPointerException("hippoSendMessageService is marked non-null but is null");
        }
        this.hippoSendMessageService = hippoSendMessageService;
    }
}

