/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.support;

import cn.hippo4j.core.executor.support.RunsOldestTaskPolicy;
import cn.hippo4j.core.executor.support.SyncPutQueuePolicy;
import cn.hippo4j.core.spi.CustomRejectedExecutionHandler;
import cn.hippo4j.core.spi.DynamicThreadPoolServiceLoader;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Stream;

public enum RejectedTypeEnum {
    CALLER_RUNS_POLICY(1, "CallerRunsPolicy", new ThreadPoolExecutor.CallerRunsPolicy()),
    ABORT_POLICY(2, "AbortPolicy", new ThreadPoolExecutor.AbortPolicy()),
    DISCARD_POLICY(3, "DiscardPolicy", new ThreadPoolExecutor.DiscardPolicy()),
    DISCARD_OLDEST_POLICY(4, "DiscardOldestPolicy", new ThreadPoolExecutor.DiscardOldestPolicy()),
    RUNS_OLDEST_TASK_POLICY(5, "RunsOldestTaskPolicy", new RunsOldestTaskPolicy()),
    SYNC_PUT_QUEUE_POLICY(6, "SyncPutQueuePolicy", new SyncPutQueuePolicy());

    public Integer type;
    public String name;
    public RejectedExecutionHandler rejectedHandler;

    private RejectedTypeEnum(Integer type, String name, RejectedExecutionHandler rejectedHandler) {
        this.type = type;
        this.name = name;
        this.rejectedHandler = rejectedHandler;
    }

    public static RejectedExecutionHandler createPolicy(String name) {
        RejectedTypeEnum rejectedTypeEnum = Stream.of(RejectedTypeEnum.values()).filter(each -> Objects.equals(each.name, name)).findFirst().orElse(null);
        if (rejectedTypeEnum != null) {
            return rejectedTypeEnum.rejectedHandler;
        }
        Collection<CustomRejectedExecutionHandler> customRejectedExecutionHandlers = DynamicThreadPoolServiceLoader.getSingletonServiceInstances(CustomRejectedExecutionHandler.class);
        Optional<RejectedExecutionHandler> customRejected = customRejectedExecutionHandlers.stream().filter(each -> Objects.equals(name, each.getName())).map(each -> each.generateRejected()).findFirst();
        return customRejected.orElse(RejectedTypeEnum.ABORT_POLICY.rejectedHandler);
    }

    public static RejectedExecutionHandler createPolicy(int type) {
        Optional<RejectedExecutionHandler> rejectedTypeEnum = Stream.of(RejectedTypeEnum.values()).filter(each -> Objects.equals(type, each.type)).map(each -> each.rejectedHandler).findFirst();
        RejectedExecutionHandler resultRejected = rejectedTypeEnum.orElseGet(() -> {
            Collection<CustomRejectedExecutionHandler> customRejectedExecutionHandlers = DynamicThreadPoolServiceLoader.getSingletonServiceInstances(CustomRejectedExecutionHandler.class);
            Optional<RejectedExecutionHandler> customRejected = customRejectedExecutionHandlers.stream().filter(each -> Objects.equals(type, each.getType())).map(each -> each.generateRejected()).findFirst();
            return customRejected.orElse(RejectedTypeEnum.ABORT_POLICY.rejectedHandler);
        });
        return resultRejected;
    }

    public static String getRejectedNameByType(int type) {
        return RejectedTypeEnum.createPolicy(type).getClass().getSimpleName();
    }

    static {
        DynamicThreadPoolServiceLoader.register(CustomRejectedExecutionHandler.class);
    }
}

