/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.resource;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.util.CharsetUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;

public class StringResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private String data;
    private String name;
    private Charset charset;

    public StringResource(String data) {
        this(data, null);
    }

    public StringResource(String data, String name) {
        this(data, name, CharsetUtil.CHARSET_UTF_8);
    }

    public StringResource(String data, String name, Charset charset) {
        this.data = data;
        this.name = name;
        this.charset = charset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return IoUtil.getReader(new StringReader(this.data));
    }

    @Override
    public String readStr(Charset charset) throws IORuntimeException {
        return this.data;
    }

    @Override
    public String readUtf8Str() throws IORuntimeException {
        return this.data;
    }

    @Override
    public byte[] readBytes() throws IORuntimeException {
        return this.data.getBytes(this.charset);
    }
}

