/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;

public class PrimitiveConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private Class<?> targetType;

    public PrimitiveConverter(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("PrimitiveConverter not allow null target type!");
        }
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException("[" + clazz + "] is not a primitive class!");
        }
        this.targetType = clazz;
    }

    @Override
    protected Object convertInternal(Object value) {
        try {
            if (Byte.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                if (value instanceof Boolean) {
                    return BooleanUtil.toByte((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Byte.parseByte(valueStr);
            }
            if (Short.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                if (value instanceof Boolean) {
                    return BooleanUtil.toShort((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Short.parseShort(valueStr);
            }
            if (Integer.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof Boolean) {
                    return BooleanUtil.toInt((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return NumberUtil.parseInt(valueStr);
            }
            if (Long.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof Boolean) {
                    return BooleanUtil.toLong((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return NumberUtil.parseLong(valueStr);
            }
            if (Float.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                if (value instanceof Boolean) {
                    return Float.valueOf(BooleanUtil.toFloat((Boolean)value));
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Float.valueOf(Float.parseFloat(valueStr));
            }
            if (Double.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                if (value instanceof Boolean) {
                    return BooleanUtil.toDouble((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Double.parseDouble(valueStr);
            }
            if (Character.TYPE == this.targetType) {
                if (value instanceof Character) {
                    return Character.valueOf(((Character)value).charValue());
                }
                if (value instanceof Boolean) {
                    return Character.valueOf(BooleanUtil.toChar((Boolean)value));
                }
                String valueStr = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr)) {
                    return 0;
                }
                return Character.valueOf(valueStr.charAt(0));
            }
            if (Boolean.TYPE == this.targetType) {
                if (value instanceof Boolean) {
                    return (boolean)((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                return BooleanUtil.toBoolean(valueStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    protected String convertToStr(Object value) {
        return StrUtil.trim(super.convertToStr(value));
    }

    @Override
    public Class<Object> getTargetType() {
        return this.targetType;
    }
}

