/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.util.StrUtil;

public enum ContentType {
    FORM_URLENCODED("application/x-www-form-urlencoded"),
    MULTIPART("multipart/form-data"),
    JSON("application/json"),
    XML("application/xml");

    private String value;

    private ContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static boolean isFormUrlEncoed(String contentType) {
        return FORM_URLENCODED.toString().equals(contentType);
    }

    public static ContentType get(String body) {
        ContentType contentType = null;
        if (StrUtil.isNotBlank((CharSequence)body)) {
            char firstChar = body.charAt(0);
            switch (firstChar) {
                case '[': 
                case '{': {
                    contentType = JSON;
                    break;
                }
                case '<': {
                    contentType = XML;
                    break;
                }
            }
        }
        return contentType;
    }
}

