/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.webservice;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;

public class SoapRequest {
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml;charset=";
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private String url;
    private String namespace;
    private String method;
    private Map<String, String> params;

    public SoapRequest(String url, String namespace) {
        this.url = url;
        this.namespace = namespace;
    }

    public SoapRequest setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public SoapRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public SoapRequest setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public SoapRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public SoapRequest setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public SoapRequest addParam(String name, String value) {
        Map<String, String> params = this.params;
        if (null == params) {
            this.params = params = new LinkedHashMap<String, String>();
        }
        params.put(name, value);
        return this;
    }

    public String execute() {
        return HttpRequest.post(this.url).body(this.toSoapXml()).contentType(this.getXmlContentType()).execute().body();
    }

    private String toSoapXml() {
        StringBuilder sb = StrUtil.builder();
        sb.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n");
        sb.append("  <soap:Body>\n");
        Assert.notBlank((String)this.method, (String)"Method must be not blank !", (Object[])new Object[0]);
        sb.append("    <").append(this.method).append(" xmlns=\"").append(this.namespace).append("\">\n");
        if (null != this.params) {
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                sb.append("      <").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">\n");
            }
        }
        sb.append("    </").append(this.method).append(">\n");
        sb.append("  </soap:Body>\n");
        sb.append("</soap:Envelope>");
        return sb.toString();
    }

    private String getXmlContentType() {
        return TEXT_XML_CONTENT_TYPE.concat(this.charset.toString());
    }
}

