/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HttpUtil {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(.*)");
    public static final Pattern META_CHARSET_PATTERN = Pattern.compile("<meta.*?charset=(.*?)\"");

    public static String encodeUtf8(String content) {
        return HttpUtil.encode(content, "UTF-8");
    }

    public static String encode(String content, Charset charset) {
        if (null == charset) {
            charset = CharsetUtil.defaultCharset();
        }
        return HttpUtil.encode(content, charset.name());
    }

    public static String encode(String content, String charsetStr) throws HttpException {
        if (StrUtil.isBlank((CharSequence)content)) {
            return content;
        }
        String encodeContent = null;
        try {
            encodeContent = URLEncoder.encode(content, charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpException(StrUtil.format((CharSequence)"Unsupported encoding: [{}]", (Object[])new Object[]{charsetStr}), e);
        }
        return encodeContent;
    }

    public static String decode(String content, Charset charset) {
        return HttpUtil.decode(content, charset.name());
    }

    public static String decode(String content, String charsetStr) {
        if (StrUtil.isBlank((CharSequence)content)) {
            return content;
        }
        String encodeContnt = null;
        try {
            encodeContnt = URLDecoder.decode(content, charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpException(StrUtil.format((CharSequence)"Unsupported encoding: [{}]", (Object[])new Object[]{charsetStr}), e);
        }
        return encodeContnt;
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String ip;
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayUtil.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        for (String header : headers) {
            ip = request.getHeader(header);
            if (HttpUtil.isUnknow(ip)) continue;
            return HttpUtil.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return HttpUtil.getMultistageReverseProxyIp(ip);
    }

    public static boolean isHttps(String url) {
        return url.toLowerCase().startsWith("https");
    }

    public static HttpRequest createRequest(Method method, String url) {
        return new HttpRequest(url).method(method);
    }

    public static HttpRequest createGet(String url) {
        return HttpRequest.get(url);
    }

    public static HttpRequest createPost(String url) {
        return HttpRequest.post(url);
    }

    public static String get(String urlString, Charset customCharset) {
        return ((HttpRequest)HttpRequest.get(urlString).charset(customCharset)).execute().body();
    }

    public static String get(String urlString) {
        return HttpUtil.get(urlString, -1);
    }

    public static String get(String urlString, int timeout) {
        return HttpRequest.get(urlString).timeout(timeout).execute().body();
    }

    public static String get(String urlString, Map<String, Object> paramMap) {
        return HttpRequest.get(urlString).form(paramMap).execute().body();
    }

    public static String get(String urlString, Map<String, Object> paramMap, int timeout) {
        return HttpRequest.get(urlString).form(paramMap).timeout(timeout).execute().body();
    }

    public static String post(String urlString, Map<String, Object> paramMap) {
        return HttpUtil.post(urlString, paramMap, -1);
    }

    public static String post(String urlString, Map<String, Object> paramMap, int timeout) {
        return HttpRequest.post(urlString).form(paramMap).timeout(timeout).execute().body();
    }

    public static String post(String urlString, String body) {
        return HttpUtil.post(urlString, body, -1);
    }

    public static String post(String urlString, String body, int timeout) {
        return HttpRequest.post(urlString).timeout(timeout).body(body).execute().body();
    }

    public static String downloadString(String url, String customCharsetName) {
        return HttpUtil.downloadString(url, CharsetUtil.charset((String)customCharsetName), null);
    }

    public static String downloadString(String url, Charset customCharset) {
        return HttpUtil.downloadString(url, customCharset, null);
    }

    public static String downloadString(String url, Charset customCharset, StreamProgress streamPress) {
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new NullPointerException("[url] is null!");
        }
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        HttpUtil.download(url, (OutputStream)out, true, streamPress);
        return null == customCharset ? out.toString() : out.toString(customCharset);
    }

    public static long downloadFile(String url, String dest) {
        return HttpUtil.downloadFile(url, FileUtil.file((String)dest));
    }

    public static long downloadFile(String url, File destFile) {
        return HttpUtil.downloadFile(url, destFile, null);
    }

    public static long downloadFile(String url, File destFile, int timeout) {
        return HttpUtil.downloadFile(url, destFile, timeout, null);
    }

    public static long downloadFile(String url, File destFile, StreamProgress streamProgress) {
        return HttpUtil.downloadFile(url, destFile, -1, streamProgress);
    }

    public static long downloadFile(String url, File destFile, int timeout, StreamProgress streamProgress) {
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new NullPointerException("[url] is null!");
        }
        if (null == destFile) {
            throw new NullPointerException("[destFile] is null!");
        }
        HttpResponse response = HttpRequest.get(url).timeout(timeout).executeAsync();
        if (!response.isOk()) {
            throw new HttpException("Server response error with status code: [{}]", response.getStatus());
        }
        return response.writeBody(destFile, streamProgress);
    }

    public static long download(String url, OutputStream out, boolean isCloseOut) {
        return HttpUtil.download(url, out, isCloseOut, null);
    }

    public static long download(String url, OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new NullPointerException("[url] is null!");
        }
        if (null == out) {
            throw new NullPointerException("[out] is null!");
        }
        HttpResponse response = HttpRequest.get(url).executeAsync();
        if (!response.isOk()) {
            throw new HttpException("Server response error with status code: [{}]", response.getStatus());
        }
        return response.writeBody(out, isCloseOut, streamProgress);
    }

    public static String toParams(Map<String, ?> paramMap) {
        return HttpUtil.toParams(paramMap, CharsetUtil.CHARSET_UTF_8);
    }

    public static String toParams(Map<String, Object> paramMap, String charsetName) {
        return HttpUtil.toParams(paramMap, CharsetUtil.charset((String)charsetName));
    }

    public static String toParams(Map<String, ?> paramMap, Charset charset) {
        if (CollectionUtil.isEmpty(paramMap)) {
            return "";
        }
        if (null == charset) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, ?> item : paramMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            String key = item.getKey();
            Object value = item.getValue();
            if (value instanceof Iterable) {
                value = CollectionUtil.join((Iterable)((Iterable)value), (CharSequence)",");
            } else if (value instanceof Iterator) {
                value = CollectionUtil.join((Iterator)((Iterator)value), (CharSequence)",");
            }
            String valueStr = Convert.toStr(value);
            if (!StrUtil.isNotEmpty((CharSequence)key)) continue;
            sb.append(HttpUtil.encode(key, charset)).append("=");
            if (!StrUtil.isNotEmpty((CharSequence)valueStr)) continue;
            sb.append(HttpUtil.encode(valueStr, charset));
        }
        return sb.toString();
    }

    public static String encodeParams(String paramsStr, Charset charset) {
        int lastIndex;
        int i;
        String paramPart;
        if (StrUtil.isBlank((CharSequence)paramsStr)) {
            return "";
        }
        String urlPart = null;
        int pathEndPos = paramsStr.indexOf(63);
        if (pathEndPos > -1) {
            urlPart = StrUtil.subPre((CharSequence)paramsStr, (int)pathEndPos);
            paramPart = StrUtil.subSuf((CharSequence)paramsStr, (int)(pathEndPos + 1));
            if (StrUtil.isBlank((CharSequence)paramPart)) {
                return urlPart;
            }
        } else {
            paramPart = paramsStr;
        }
        StrBuilder builder = StrBuilder.create((int)(paramPart.length() + 16));
        int len = paramPart.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = paramPart.charAt(i);
            if (c == '=') {
                if (null != name) continue;
                name = pos == i ? "" : paramPart.substring(pos, i);
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (pos != i) {
                if (null == name) {
                    name = paramPart.substring(pos, i);
                    builder.append((CharSequence)HttpUtil.encode(name, charset)).append('=');
                } else {
                    builder.append((CharSequence)HttpUtil.encode(name, charset)).append('=').append((CharSequence)HttpUtil.encode(paramPart.substring(pos, i), charset)).append('&');
                }
                name = null;
            }
            pos = i + 1;
        }
        if (null != name) {
            builder.append((CharSequence)HttpUtil.encode(name, charset)).append('=');
        }
        if (pos != i) {
            if (null == name) {
                builder.append('=');
            }
            builder.append((CharSequence)HttpUtil.encode(paramPart.substring(pos, i), charset));
        }
        if ('&' == builder.charAt(lastIndex = builder.length() - 1)) {
            builder.delTo(lastIndex);
        }
        return StrUtil.isBlank((CharSequence)urlPart) ? builder.toString() : urlPart + "?" + builder.toString();
    }

    public static HashMap<String, String> decodeParamMap(String paramsStr, String charset) {
        Map<String, List<String>> paramsMap = HttpUtil.decodeParams(paramsStr, charset);
        HashMap result = MapUtil.newHashMap((int)paramsMap.size());
        for (Map.Entry<String, List<String>> entry : paramsMap.entrySet()) {
            List<String> valueList = entry.getValue();
            result.put(entry.getKey(), CollUtil.isEmpty(valueList) ? null : valueList.get(0));
        }
        return result;
    }

    public static Map<String, List<String>> decodeParams(String paramsStr, String charset) {
        int i;
        if (StrUtil.isBlank((CharSequence)paramsStr)) {
            return Collections.emptyMap();
        }
        int pathEndPos = paramsStr.indexOf(63);
        if (pathEndPos > -1) {
            paramsStr = StrUtil.subSuf((CharSequence)paramsStr, (int)(pathEndPos + 1));
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        int len = paramsStr.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = paramsStr.charAt(i);
            if (c == '=') {
                if (null == name) {
                    name = paramsStr.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (null == name && pos != i) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "", charset);
            } else if (name != null) {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i), charset);
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "", charset);
            } else {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i), charset);
            }
        } else if (name != null) {
            HttpUtil.addParam(params, name, "", charset);
        }
        return params;
    }

    public static String urlWithForm(String url, Map<String, Object> form, Charset charset, boolean isEncode) {
        if (isEncode && StrUtil.contains((CharSequence)url, (char)'?')) {
            url = HttpUtil.encodeParams(url, charset);
        }
        return HttpUtil.urlWithForm(url, HttpUtil.toParams(form, charset), charset, false);
    }

    public static String urlWithForm(String url, String queryString, Charset charset, boolean isEncode) {
        if (StrUtil.isBlank((CharSequence)queryString)) {
            if (StrUtil.contains((CharSequence)url, (char)'?')) {
                return isEncode ? HttpUtil.encodeParams(url, charset) : url;
            }
            return url;
        }
        StrBuilder urlBuilder = StrBuilder.create((int)(url.length() + queryString.length() + 16));
        int qmIndex = url.indexOf(63);
        if (qmIndex > 0) {
            urlBuilder.append((CharSequence)(isEncode ? HttpUtil.encodeParams(url, charset) : url));
            if (!StrUtil.endWith((CharSequence)url, (char)'&')) {
                urlBuilder.append('&');
            }
        } else {
            urlBuilder.append((CharSequence)url);
            if (qmIndex < 0) {
                urlBuilder.append('?');
            }
        }
        urlBuilder.append((CharSequence)(isEncode ? HttpUtil.encodeParams(queryString, charset) : queryString));
        return urlBuilder.toString();
    }

    public static String getCharset(HttpURLConnection conn) {
        if (conn == null) {
            return null;
        }
        return ReUtil.get((Pattern)CHARSET_PATTERN, (String)conn.getContentType(), (int)1);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (HttpUtil.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknow(String checkString) {
        return StrUtil.isBlank((CharSequence)checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static String getString(InputStream in, Charset charset, boolean isGetCharsetFromContent) throws IOException {
        byte[] contentBytes = IoUtil.readBytes((InputStream)in);
        return HttpUtil.getString(contentBytes, charset, isGetCharsetFromContent);
    }

    public static String getString(byte[] contentBytes, Charset charset, boolean isGetCharsetFromContent) throws IOException {
        String charsetInContentStr;
        if (null == contentBytes) {
            return null;
        }
        if (null == charset) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        String content = new String(contentBytes, charset);
        if (isGetCharsetFromContent && StrUtil.isNotBlank((CharSequence)(charsetInContentStr = ReUtil.get((Pattern)META_CHARSET_PATTERN, (String)content, (int)1)))) {
            Charset charsetInContent;
            block7: {
                charsetInContent = null;
                try {
                    charsetInContent = Charset.forName(charsetInContentStr);
                }
                catch (Exception e) {
                    if (StrUtil.containsIgnoreCase((CharSequence)charsetInContentStr, (CharSequence)"utf-8") || StrUtil.containsIgnoreCase((CharSequence)charsetInContentStr, (CharSequence)"utf8")) {
                        charsetInContent = CharsetUtil.CHARSET_UTF_8;
                    }
                    if (!StrUtil.containsIgnoreCase((CharSequence)charsetInContentStr, (CharSequence)"gbk")) break block7;
                    charsetInContent = CharsetUtil.CHARSET_GBK;
                }
            }
            if (null != charsetInContent && !charset.equals(charsetInContent)) {
                content = new String(contentBytes, charsetInContent);
            }
        }
        return content;
    }

    public static String getMimeType(String filePath) {
        return URLConnection.getFileNameMap().getContentTypeFor(filePath);
    }

    public static String getContentTypeByRequestBody(String body) {
        ContentType contentType = ContentType.get(body);
        return null == contentType ? null : contentType.toString();
    }

    private static void addParam(Map<String, List<String>> params, String name, String value, String charset) {
        name = HttpUtil.decode(name, charset);
        value = HttpUtil.decode(value, charset);
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
    }
}

