/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.useragent;

import cn.hutool.core.util.ReUtil;
import cn.hutool.http.useragent.Browser;
import cn.hutool.http.useragent.Engine;
import cn.hutool.http.useragent.OS;
import cn.hutool.http.useragent.Platform;
import cn.hutool.http.useragent.UserAgent;
import java.util.regex.Pattern;

public class UserAgentParser {
    public static UserAgent parse(String userAgentString) {
        UserAgent userAgent = new UserAgent();
        Browser browser = UserAgentParser.parseBrowser(userAgentString);
        userAgent.setBrowser(UserAgentParser.parseBrowser(userAgentString));
        userAgent.setVersion(browser.getVersion(userAgentString));
        Engine engine = UserAgentParser.parseEngine(userAgentString);
        userAgent.setEngine(engine);
        if (!engine.isUnknown()) {
            userAgent.setEngineVersion(UserAgentParser.parseEngineVersion(engine, userAgentString));
        }
        userAgent.setOs(UserAgentParser.parseOS(userAgentString));
        Platform platform = UserAgentParser.parsePlatform(userAgentString);
        userAgent.setPlatform(platform);
        userAgent.setMobile(platform.isMobile() || browser.isMobile());
        return userAgent;
    }

    private static Browser parseBrowser(String userAgentString) {
        for (Browser brower : Browser.browers) {
            if (!brower.isMatch(userAgentString)) continue;
            return brower;
        }
        return Browser.Unknown;
    }

    private static Engine parseEngine(String userAgentString) {
        for (Engine engine : Engine.engines) {
            if (!engine.isMatch(userAgentString)) continue;
            return engine;
        }
        return Engine.Unknown;
    }

    private static String parseEngineVersion(Engine engine, String userAgentString) {
        String regexp = engine.getName() + "[\\/\\- ]([\\d\\w\\.\\-]+)";
        Pattern pattern = Pattern.compile(regexp, 2);
        return ReUtil.getGroup1((Pattern)pattern, (CharSequence)userAgentString);
    }

    private static OS parseOS(String userAgentString) {
        for (OS os : OS.oses) {
            if (!os.isMatch(userAgentString)) continue;
            return os;
        }
        return OS.Unknown;
    }

    private static Platform parsePlatform(String userAgentString) {
        for (Platform platform : Platform.platforms) {
            if (!platform.isMatch(userAgentString)) continue;
            return platform;
        }
        return Platform.Unknown;
    }
}

