/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HTMLFilter;

public class HtmlUtil {
    public static final String NBSP = "&nbsp;";
    public static final String AMP = "&amp;";
    public static final String QUOTE = "&quot;";
    public static final String APOS = "&apos;";
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String RE_HTML_MARK = "(<[^<]*?>)|(<[\\s]*?/[^<]*?>)|(<[^<]*?/[\\s]*?>)";
    public static final String RE_SCRIPT = "<[\\s]*?script[^>]*?>.*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
    private static final char[][] TEXT = new char[64][];

    public static String escape(String text) {
        return HtmlUtil.encode(text, TEXT);
    }

    public static String unescape(String htmlStr) {
        if (StrUtil.isBlank((CharSequence)htmlStr)) {
            return htmlStr;
        }
        return htmlStr.replace(APOS, "'").replace("&#039;", "'").replace("&#39;", "'").replace(LT, "<").replace(GT, ">").replace(QUOTE, "\"").replace(AMP, "&").replace(NBSP, " ");
    }

    public static String cleanHtmlTag(String content) {
        return content.replaceAll(RE_HTML_MARK, "");
    }

    public static String removeHtmlTag(String content, String ... tagNames) {
        return HtmlUtil.removeHtmlTag(content, true, tagNames);
    }

    public static String unwrapHtmlTag(String content, String ... tagNames) {
        return HtmlUtil.removeHtmlTag(content, false, tagNames);
    }

    public static String removeHtmlTag(String content, boolean withTagContent, String ... tagNames) {
        String regex = null;
        for (String tagName : tagNames) {
            if (StrUtil.isBlank((CharSequence)tagName)) continue;
            tagName = tagName.trim();
            regex = withTagContent ? StrUtil.format((CharSequence)"(?i)<{}\\s*?[^>]*?/?>(.*?</{}>)?", (Object[])new Object[]{tagName, tagName}) : StrUtil.format((CharSequence)"(?i)<{}\\s*?[^>]*?>|</{}>", (Object[])new Object[]{tagName, tagName});
            content = ReUtil.delAll((String)regex, (CharSequence)content);
        }
        return content;
    }

    public static String removeHtmlAttr(String content, String ... attrs) {
        String regex = null;
        for (String attr : attrs) {
            regex = StrUtil.format((CharSequence)"(?i)\\s*{}=([\"']).*?\\1", (Object[])new Object[]{attr});
            content = content.replaceAll(regex, "");
        }
        return content;
    }

    public static String removeAllHtmlAttr(String content, String ... tagNames) {
        String regex = null;
        for (String tagName : tagNames) {
            regex = StrUtil.format((CharSequence)"(?i)<{}[^>]*?>", (Object[])new Object[]{tagName});
            content = content.replaceAll(regex, StrUtil.format((CharSequence)"<{}>", (Object[])new Object[]{tagName}));
        }
        return content;
    }

    private static String encode(String text, char[][] array) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c < '@') {
                buffer.append(array[c]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String filter(String htmlContent) {
        return new HTMLFilter().filter(htmlContent);
    }

    static {
        for (int i = 0; i < 64; ++i) {
            HtmlUtil.TEXT[i] = new char[]{(char)i};
        }
        HtmlUtil.TEXT[39] = "&#039;".toCharArray();
        HtmlUtil.TEXT[34] = QUOTE.toCharArray();
        HtmlUtil.TEXT[38] = AMP.toCharArray();
        HtmlUtil.TEXT[60] = LT.toCharArray();
        HtmlUtil.TEXT[62] = GT.toCharArray();
    }
}

