/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.server.action;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.http.server.HttpServerRequest;
import cn.hutool.http.server.HttpServerResponse;
import cn.hutool.http.server.action.Action;
import java.io.File;
import java.util.List;

public class RootAction
implements Action {
    public static final String DEFAULT_INDEX_FILE_NAME = "index.html";
    private final String rootDir;
    private final List<String> indexFileNames;

    public RootAction(String rootDir) {
        this(rootDir, DEFAULT_INDEX_FILE_NAME);
    }

    public RootAction(String rootDir, String ... indexFileNames) {
        this.rootDir = rootDir;
        this.indexFileNames = CollUtil.toList((Object[])indexFileNames);
    }

    @Override
    public void doAction(HttpServerRequest request, HttpServerResponse response) {
        String path = request.getPath();
        File file = FileUtil.file((String)this.rootDir, (String)path);
        if (file.exists() && file.isDirectory()) {
            for (String indexFileName : this.indexFileNames) {
                if (!(file = FileUtil.file((File)file, (String)indexFileName)).exists() || !file.isFile()) continue;
                response.write(file);
            }
        }
        response.send404("404 Not Found !");
    }
}

