/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.server;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.server.HttpServerBase;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class HttpServerResponse
extends HttpServerBase {
    private Charset charset;
    private boolean isSendCode;

    public HttpServerResponse(HttpExchange httpExchange) {
        super(httpExchange);
    }

    public HttpServerResponse send(int httpStatusCode) {
        return this.send(httpStatusCode, 0L);
    }

    public HttpServerResponse sendOk() {
        return this.send(200);
    }

    public HttpServerResponse send404(String content) {
        return this.sendError(404, content);
    }

    public HttpServerResponse sendError(int errorCode, String content) {
        this.send(errorCode);
        this.setContentType(ContentType.TEXT_HTML.toString());
        return this.write(content);
    }

    public HttpServerResponse send(int httpStatusCode, long bodyLength) {
        if (this.isSendCode) {
            throw new IORuntimeException("Http status code has been send!");
        }
        try {
            this.httpExchange.sendResponseHeaders(httpStatusCode, bodyLength);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        this.isSendCode = true;
        return this;
    }

    public Headers getHeaders() {
        if (!this.isSendCode) {
            this.sendOk();
        }
        return this.httpExchange.getResponseHeaders();
    }

    public HttpServerResponse addHeader(String header, String value) {
        this.getHeaders().add(header, value);
        return this;
    }

    public HttpServerResponse setHeader(Header header, String value) {
        return this.setHeader(header.getValue(), value);
    }

    public HttpServerResponse setHeader(String header, String value) {
        this.getHeaders().set(header, value);
        return this;
    }

    public HttpServerResponse setHeader(String header, List<String> value) {
        this.getHeaders().put(header, value);
        return this;
    }

    public HttpServerResponse setHeaders(Map<String, List<String>> headers) {
        this.getHeaders().putAll((Map<? extends String, ? extends List<String>>)headers);
        return this;
    }

    public HttpServerResponse setContentType(String contentType) {
        if (null != contentType && null != this.charset && !contentType.contains(";charset=")) {
            contentType = ContentType.build(contentType, this.charset);
        }
        return this.setHeader(Header.CONTENT_TYPE, contentType);
    }

    public HttpServerResponse setContentLength(long contentLength) {
        return this.setHeader(Header.CONTENT_LENGTH, String.valueOf(contentLength));
    }

    public HttpServerResponse setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public HttpServerResponse setAttr(String name, Object value) {
        this.httpExchange.setAttribute(name, value);
        return this;
    }

    public OutputStream getOut() {
        if (!this.isSendCode) {
            this.sendOk();
        }
        return this.httpExchange.getResponseBody();
    }

    public PrintWriter getWriter() {
        Charset charset = (Charset)ObjectUtil.defaultIfNull((Object)this.charset, (Object)DEFAULT_CHARSET);
        return new PrintWriter(new OutputStreamWriter(this.getOut(), charset));
    }

    public HttpServerResponse write(String data, String contentType) {
        this.setContentType(contentType);
        return this.write(data);
    }

    public HttpServerResponse write(String data) {
        Charset charset = (Charset)ObjectUtil.defaultIfNull((Object)this.charset, (Object)DEFAULT_CHARSET);
        return this.write(StrUtil.bytes((CharSequence)data, (Charset)charset));
    }

    public HttpServerResponse write(byte[] data, String contentType) {
        this.setContentType(contentType);
        return this.write(data);
    }

    public HttpServerResponse write(byte[] data) {
        return this.write(new ByteArrayInputStream(data));
    }

    public HttpServerResponse write(InputStream in, String contentType) {
        this.setContentType(contentType);
        return this.write(in);
    }

    public HttpServerResponse write(InputStream in) {
        OutputStream out = null;
        try {
            out = this.getOut();
            IoUtil.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IoUtil.close((Closeable)out);
            IoUtil.close((Closeable)in);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpServerResponse write(File file) {
        String fileName = file.getName();
        String contentType = (String)ObjectUtil.defaultIfNull((Object)HttpUtil.getMimeType(fileName), (Object)"application/octet-stream");
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream((File)file);
            this.write(in, contentType, fileName);
        }
        finally {
            IoUtil.close((Closeable)in);
        }
        return this;
    }

    public void write(InputStream in, String contentType, String fileName) {
        Charset charset = (Charset)ObjectUtil.defaultIfNull((Object)this.charset, (Object)DEFAULT_CHARSET);
        this.setHeader("Content-Disposition", StrUtil.format((CharSequence)"attachment;filename={}", (Object[])new Object[]{URLUtil.encode((String)fileName, (Charset)charset)}));
        this.setContentType(contentType);
        this.write(in);
    }
}

