/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.common;

import cn.jpush.api.common.APIConnectionException;
import cn.jpush.api.common.APIRequestException;
import cn.jpush.api.common.IHttpClient;
import cn.jpush.api.common.ResponseWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeHttpClient
implements IHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(NativeHttpClient.class);
    private int _maxRetryTimes = 0;

    public NativeHttpClient() {
        this(3);
    }

    public NativeHttpClient(int maxRetryTimes) {
        this._maxRetryTimes = maxRetryTimes;
        LOG.info("Created instance with _maxRetryTimes = " + this._maxRetryTimes);
        this.initSSL();
    }

    @Override
    public ResponseWrapper sendGet(String url, String params, String authCode) throws APIConnectionException, APIRequestException {
        return this.sendRequest(url, params, IHttpClient.RequestMethod.GET, authCode);
    }

    @Override
    public ResponseWrapper sendPost(String url, String content, String authCode) throws APIConnectionException, APIRequestException {
        return this.sendRequest(url, content, IHttpClient.RequestMethod.POST, authCode);
    }

    public ResponseWrapper sendRequest(String url, String content, IHttpClient.RequestMethod method, String authCode) throws APIConnectionException, APIRequestException {
        ResponseWrapper response = null;
        int retryTimes = 0;
        while (true) {
            try {
                response = this._sendRequest(url, content, method, authCode);
            }
            catch (SocketTimeoutException e) {
                if (retryTimes >= this._maxRetryTimes) {
                    throw new APIConnectionException(e);
                }
                LOG.debug("connect timed out - retry again - " + (retryTimes + 1));
                ++retryTimes;
                continue;
            }
            break;
        }
        return response;
    }

    private ResponseWrapper _sendRequest(String url, String content, IHttpClient.RequestMethod method, String authCode) throws APIConnectionException, APIRequestException, SocketTimeoutException {
        ResponseWrapper wrapper;
        block27: {
            LOG.debug("Send request to - " + url);
            if (null != content) {
                LOG.debug("Request Content - " + content);
            }
            HttpURLConnection conn = null;
            OutputStream out = null;
            StringBuffer sb = new StringBuffer();
            wrapper = new ResponseWrapper();
            try {
                int len;
                URL aUrl = new URL(url);
                conn = (HttpURLConnection)aUrl.openConnection();
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(30000);
                conn.setUseCaches(false);
                conn.setRequestMethod(method.name());
                conn.setRequestProperty("User-Agent", "JPush-API-Java-Client");
                conn.setRequestProperty("Connection", "Keep-Alive");
                conn.setRequestProperty("Accept-Charset", "UTF-8");
                conn.setRequestProperty("Charset", "UTF-8");
                conn.setRequestProperty("Authorization", authCode);
                if (IHttpClient.RequestMethod.POST == method) {
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Content-Type", "application/json");
                    byte[] data = content.getBytes("UTF-8");
                    conn.setRequestProperty("Content-Length", String.valueOf(data.length));
                    out = conn.getOutputStream();
                    out.write(data);
                    out.flush();
                } else {
                    conn.setDoOutput(false);
                }
                int status = conn.getResponseCode();
                InputStream in = null;
                in = status == 200 ? conn.getInputStream() : conn.getErrorStream();
                InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                char[] buff = new char[1024];
                while ((len = reader.read(buff)) > 0) {
                    sb.append(buff, 0, len);
                }
                String responseContent = sb.toString();
                wrapper.responseCode = status;
                wrapper.responseContent = responseContent;
                String quota = conn.getHeaderField("X-Rate-Limit-Limit");
                String remaining = conn.getHeaderField("X-Rate-Limit-Remaining");
                String reset = conn.getHeaderField("X-Rate-Limit-Reset");
                wrapper.setRateLimit(quota, remaining, reset);
                if (status == 200) {
                    LOG.debug("Succeed to get response - 200 OK");
                    LOG.debug("Response Content - " + responseContent);
                    break block27;
                }
                if (status > 200 && status < 400) {
                    LOG.warn("Normal response but unexpected - responseCode:" + status + ", responseContent:" + responseContent);
                    break block27;
                }
                LOG.warn("Got error response - responseCode:" + status + ", responseContent:" + responseContent);
                switch (status) {
                    case 400: {
                        LOG.error("Your request params is invalid. Please check them according to error message.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 401: {
                        LOG.error("Authentication failed! Please check authentication params according to docs.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 403: {
                        LOG.error("Request is forbidden! Maybe your appkey is listed in blacklist?");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 410: {
                        LOG.error("Request resource is no longer in service. Please according to notice on official website.");
                        wrapper.setErrorObject();
                    }
                    case 429: {
                        LOG.error("Too many requests! Please review your appkey's request quota.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 500: 
                    case 502: 
                    case 503: 
                    case 504: {
                        LOG.error("Seems encountered server error. Maybe JPush is in maintenance? Please retry later.");
                        break;
                    }
                    default: {
                        LOG.error("Unexpected response.");
                    }
                }
                throw new APIRequestException(wrapper);
            }
            catch (SocketTimeoutException e) {
                if (e.getMessage().contains("connect timed out")) {
                    throw e;
                }
                LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
                throw new APIConnectionException("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", e);
            }
            catch (IOException e) {
                LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
                throw new APIConnectionException("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", e);
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LOG.error("Failed to close stream.", (Throwable)e);
                    }
                }
                if (null != conn) {
                    conn.disconnect();
                }
            }
        }
        return wrapper;
    }

    protected void initSSL() {
        TrustManager[] tmCerts = new TrustManager[]{new SimpleTrustManager()};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, tmCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            SimpleHostnameVerifier hostnameVerifier = new SimpleHostnameVerifier();
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
        catch (Exception e) {
            LOG.error("Init SSL error", (Throwable)e);
        }
    }

    public static class SimpleTrustManager
    implements TrustManager,
    X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public static class SimpleHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

